<?php

namespace App\Http\Controllers;

use App\Models\Plainte;
use App\Models\Appel;
use Illuminate\Http\Request;

class AppelController extends Controller
{
    public function create(Plainte $plainte)
    {
        if (!$plainte->canBeAppealed()) {
            abort(403, 'Cette plainte ne peut plus faire l\'objet d\'un appel');
        }

        return view('appeals.create', compact('plainte'));
    }

    public function store(Request $request, Plainte $plainte)
    {
        $validated = $request->validate([
            'motif_appel' => 'required|string',
        ]);

        $appeal = Appel::create([
            'plainte_id' => $plainte->id,
            'appellant_id' => $plainte->plaignant_id,
            'motif_appel' => $validated['motif_appel'],
            'date_appel' => now(),
            'date_limite' => now()->addDays(7),
        ]);

        $plainte->update(['statut' => 'en_appel']);

        return redirect()->route('plaintes.show', $plainte)
                        ->with('success', 'Appel enregistré avec succès');
    }

    public function processAppeal(Request $request, Appel $appeal)
    {
        $validated = $request->validate([
            'statut' => 'required|in:accepte,rejete',
            'decision_appel' => 'required|string',
        ]);

        $appeal->update([
            ...$validated,
            'date_decision_appel' => now(),
        ]);

        // Mettre à jour le statut de la plainte selon la décision d'appel
        $newStatus = $validated['statut'] === 'accepte' ? 'en_examen' : 'clos';
        $appeal->plainte->update(['statut' => $newStatus]);

        return back()->with('success', 'Décision d\'appel enregistrée');
    }
}
