<?php

namespace App\Http\Controllers;

use App\Models\Plainte;
use App\Models\Financement;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\PlaintesExport;
use App\Exports\FinancementsExport;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;

class ExportController extends Controller
{
    /**
     * Export des plaintes au format Excel
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function exportPlaintesExcel(Request $request)
    {
        $filters = $request->all();
        $filename = 'plaintes_' . now()->format('Y-m-d_His') . '.xlsx';
        
        return Excel::download(new PlaintesExport($filters), $filename);
    }

    /**
     * Export des plaintes au format CSV
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function exportPlaintesCSV(Request $request)
    {
        $filters = $request->all();
        $filename = 'plaintes_' . now()->format('Y-m-d_His') . '.csv';
        
        return Excel::download(new PlaintesExport($filters), $filename, \Maatwebsite\Excel\Excel::CSV, [
            'Content-Type' => 'text/csv',
        ]);
    }

    /**
     * Export des plaintes au format PDF
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function exportPlaintesPDF(Request $request)
    {
        $filters = $request->all();
        $query = Plainte::query();

        // Appliquer les filtres
        if (!empty($filters['statut'])) {
            $query->where('statut', $filters['statut']);
        }

        if (!empty($filters['date_debut'])) {
            $query->whereDate('created_at', '>=', $filters['date_debut']);
        }

        if (!empty($filters['date_fin'])) {
            $query->whereDate('created_at', '<=', $filters['date_fin']);
        }

        $plaintes = $query->get();
        $filename = 'plaintes_' . now()->format('Y-m-d_His') . '.pdf';
        
        $pdf = Pdf::loadView('exports.plaintes-pdf', compact('plaintes'));
        return $pdf->download($filename);
    }

    /**
     * Export des demandes de financement au format Excel
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function exportFinancementsExcel(Request $request)
    {
        $filters = $request->all();
        $filename = 'financements_' . now()->format('Y-m-d_His') . '.xlsx';
        
        return Excel::download(new FinancementsExport($filters), $filename);
    }

    /**
     * Export des demandes de financement au format CSV
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function exportFinancementsCSV(Request $request)
    {
        $filters = $request->all();
        $filename = 'financements_' . now()->format('Y-m-d_His') . '.csv';
        
        return Excel::download(new FinancementsExport($filters), $filename, \Maatwebsite\Excel\Excel::CSV, [
            'Content-Type' => 'text/csv',
        ]);
    }

    /**
     * Export des demandes de financement au format PDF
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function exportFinancementsPDF(Request $request)
    {
        $filters = $request->all();
        $query = Financement::query();

        // Appliquer les filtres
        if (!empty($filters['statut'])) {
            $query->where('statut', $filters['statut']);
        }

        if (!empty($filters['date_debut'])) {
            $query->whereDate('created_at', '>=', $filters['date_debut']);
        }

        if (!empty($filters['date_fin'])) {
            $query->whereDate('created_at', '<=', $filters['date_fin']);
        }

        $financements = $query->get();
        $filename = 'financements_' . now()->format('Y-m-d_His') . '.pdf';
        
        $pdf = PDF::loadView('exports.financements-pdf', compact('financements'));
        return $pdf->download($filename);
    }
}
