<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class LanguageController extends Controller
{
    public function switchLang($lang)
    {
        if (in_array($lang, ['en', 'fr'])) {
            Session::put('applocale', $lang);
            App::setLocale($lang);
            
            // Store the locale in a cookie that expires in 1 year
            return back()->withCookie(cookie()->forever('locale', $lang));
        }
        
        return back();
    }
    
    public function setLocale()
    {
        $locale = request()->get('locale');
        if (in_array($locale, ['en', 'fr'])) {
            Session::put('applocale', $locale);
            App::setLocale($locale);
            
            // Store the locale in a cookie that expires in 1 year
            return response()->json(['success' => true])
                ->withCookie(cookie()->forever('locale', $locale));
        }
        
        return response()->json(['success' => false]);
    }
}
