<?php

namespace App\Http\Controllers;

use App\Models\Parametre;
use Illuminate\Http\Request;

class ParametreController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {

        $parametres = Parametre::when($request->search, function($query, $search) {
                $query->where('libelle_long', 'like', "%{$search}%")
                      ->orWhere('libelle_long', 'like', "%{$search}%");
            })
            ->when($request->type !== null, function($query) use ($request) {
                $query->where('type', $request->type);
            })
            ->paginate(10);
        $types= Parametre::types();
        return view('admin.parametres.index')
        ->with('types',$types)
        ->with('parametres',$parametres);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $types= Parametre::types();
        return view('admin.parametres.create', compact('types'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        Parametre::create($request->all());
        session()->flash('success', 'Parametre créé avec succès');
        return redirect()->route('parametres.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(Parametre $parametre)
    {

        return view('admin.parametres.show', compact('parametre'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Parametre $parametre)
    {
        $types= Parametre::types();
        return view('admin.parametres.edit', compact('parametre', 'types'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Parametre $parametre)
    {
        $parametre->update($request->all());
        session()->flash('success', 'Parametre modifié avec succès');
        return redirect()->route('parametres.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Parametre $parametre)
    {
        $parametre->delete();
        session()->flash('success', 'Parametre supprimé avec succès');
        return redirect()->route('parametres.index');
    }
}
