<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateFinancementRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "nom_structure" => "required|string|max:255",
            "statut_juridique" => "required|string|in:association,ong,cooperative,entreprise,groupement,autre",
            "email" => "required|email",
            "telephone" => "required|string|max:20",
            "adresse" => "required|string|max:1000",
            "numero_ifu" => "required|string|max:50",
            "numero_rccm" => "required|string|max:50",
            "region" => "required|string|max:100",
            "commune" => "required|string|max:100",
            "personne_habilitee" => "required|string|max:255",
            "intitule_activite" => "required|string|max:255",
            "resume_activite" => "required|string|max:5000",
            "periode_mise_en_oeuvre" => "required|string|max:100",
            "organisations_partenaires" => "required|string|max:500",
            "cout_total" => "required|numeric|min:0",
            "montant_sollicite" => "required|numeric|min:0",
            "resultat_1" => "required|string|max:500",
            "resultat_2" => "nullable|string|max:500",
            "resultat_3" => "nullable|string|max:500",
            "resultat_4" => "nullable|string|max:500",
            "resultat_5" => "nullable|string|max:500",
            "resultat_6" => "nullable|string|max:500",
            "guichet" => "required|array",
            "guichet.*" => "required|string|max:100",
            "cible_1" => "required|string|max:100",
            "cible_2" => "nullable|string|max:100",
            "cible_3" => "nullable|string|max:100",
            "cible_4" => "nullable|string|max:100",
            "contribution_visibilite" => "required|string|max:100",
            "piece_jointes" => "required|array",
            "piece_jointes.*" => "required|file|mimes:pdf,doc,docx|max:10240",
        ];
    }
}
