<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\RedirectResponse;

class PlainteStoreRequest extends FormRequest
{
    public function rules()
    {
        return [
            'plaignant.nom' => 'required_if:est_anonyme,0|string|max:255',
            'plaignant.prenom' => 'nullable|string|max:255',
            'plaignant.telephone' => 'nullable|string|max:20',
            'plaignant.email' => 'nullable|email|max:255',
            'plaignant.adresse' => 'nullable|string',
            'plaignant.sexe' => 'nullable|in:M,F',
            'plaignant.handicap' => 'nullable|boolean',
            'plaignant.type' => 'required|in:individu,groupe,communaute',
            
            'objet' => 'required|string|max:500',
            'description' => 'required|string',
            // 'canal_reception' => 'required|in:boite_plaintes,verbal,courrier_physique,email,telephone,sms,whatsapp,web',
            'type_plainte' => 'required',
            'est_anonyme' => 'nullable|boolean',
            'est_lanceur_alerte' => 'nullable|boolean',
            
            'preuves.*' => 'file|max:10240|mimes:pdf,doc,docx,jpg,jpeg,png,mp3,mp4',
        ];
        
    }
    public function response(array $errors): RedirectResponse
    {
        return back()->withErrors($errors)->withInput();
    }

}
