<?php

namespace App\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;

class ProcessComplaintJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $plainte;

    public function __construct(Plainte $plainte)
    {
        $this->plainte = $plainte;
    }

    public function handle(ComplaintNotificationService $notificationService)
    {
        // Traitement automatique de la plainte
        $this->categorizeComplaint();
        $this->assignComplaint();
        $this->sendNotifications($notificationService);
    }

    private function categorizeComplaint()
    {
        // Logique de catégorisation automatique basée sur les mots-clés
        $sensibleKeywords = [
            'viol', 'abus', 'violence', 'discrimination', 'corruption',
            'détournement', 'harcèlement', 'menace', 'décès'
        ];

        $description = strtolower($this->plainte->description . ' ' . $this->plainte->objet);
        
        foreach ($sensibleKeywords as $keyword) {
            if (str_contains($description, $keyword)) {
                $this->plainte->update(['niveau_sensibilite' => 'sensible']);
                break;
            }
        }
    }

    private function assignComplaint()
    {
        // Logique d'assignation automatique
        $assignment = match($this->plainte->niveau_sensibilite) {
            'sensible' => User::where('role', 'senior_investigator')->inRandomOrder()->first(),
            'non_sensible' => User::where('role', 'investigator')->inRandomOrder()->first(),
            default => User::where('role', 'investigator')->inRandomOrder()->first()
        };

        if ($assignment) {
            $this->plainte->update(['assigned_to' => $assignment->id]);
        }
    }

    private function sendNotifications(ComplaintNotificationService $notificationService)
    {
        $notificationService->sendAccuseReception($this->plainte);
    }
}
