<?php

namespace App\Mail;

use App\Models\Plainte;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class AccuseReceptionMail extends Mailable
{
    use Queueable, SerializesModels;

    public $plainte;
    public $accuseMessage;

    public function __construct(Plainte $plainte, string $accuseMessage)
    {
        $this->plainte = $plainte;
        $this->accuseMessage = $accuseMessage;
    }

    public function build()
    {
        return $this->subject("Accusé de réception - Plainte {$this->plainte->numero}")
                   ->view('emails.accuse-reception', [
                       'plainte' => $this->plainte,
                       'accuseMessage' => $this->accuseMessage
                   ]);
    }
}
