<?php

namespace App\Mail;

use App\Models\Plainte;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class StatusChangeMail extends Mailable
{
    use Queueable, SerializesModels;
    protected $plainte;
    protected $statusMessage;

    public function __construct(Plainte $plainte, string $message)
    {
        $this->plainte = $plainte;
        $this->statusMessage = $message;
    }

    public function build()
    {
        return $this->subject("Changement de statut - Plainte {$this->plainte->numero}")
                   ->view('emails.status-change', [
                       'plainte' => $this->plainte,
                       'statusMessage' => $this->statusMessage,
                   ]);
    }
}
