<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class Parametre extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;

    protected $fillable = [
        'libelle_court',
        'libelle_long',
        'type',
        'ordre',
        'description'
    ];

    protected $casts = [
        'ordre' => 'integer'
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll()
            ->logOnlyDirty()
            ->dontSubmitEmptyLogs()
            ->setDescriptionForEvent(fn(string $eventName) => "Parametre has been {$eventName}");
    }


    public function scopeCategorieOeuvre($query)
    {
        return $query->where('type', 'categorie_oeuvre');
    }
    public function scopeCategorieExposant($query)
    {
        return $query->where('type', 'categorie_exposant');
    }
    public function scopeMoyenTransport($query)
    {
        return $query->where('type', 'moyen_transport');
    }
    public function scopeTypeEspaceEnfant($query)
    {
        return $query->where('type', 'espace_enfant');
    }
    public function scopeTypeOeuvre($query)
    {
        return $query->where('type', 'oeuvre');
    }
    // Relations
    public function atelierEcritures()
    {
        return $this->hasMany(AtelierEcriture::class, 'categorie_oeuvre_id');
    }

    public function locationStandsMoyenTransport()
    {
        return $this->hasMany(LocationStand::class, 'moyen_transport_id');
    }

    public function locationStandsCategorieExposant()
    {
        return $this->hasMany(LocationStand::class, 'categorie_exposant_id');
    }

    public function espaceEnfants()
    {
        return $this->hasMany(EspaceEnfant::class, 'categorie_id');
    }

    public function oeuvres()
    {
        return $this->hasMany(Oeuvre::class, 'categorie_id');
    }

    // Scopes
    public function scopeByType($query, $type)
    {
        return $query->where('type', $type);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('ordre');
    }


    public function scopeTypes($query)
    {
        return [
            'categorie_oeuvre' => 'Categorie Oeuvre',
            'categorie_exposant' => 'Categorie Exposant',
            'moyen_transport' => 'Moyen Transport',
            'espace_enfant' => 'Espace Enfant',
            'oeuvre' => 'Oeuvre'
        ];
    }
}