<?php

namespace App\Policies;

use App\Models\Resolution;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ResolutionPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('viewAny', Resolution::class);
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Resolution $resolution): bool
    {
        return $user->can('view', $resolution) || 
               $resolution->plainte->plaignant_id === $user->id;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('create', Resolution::class);
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Resolution $resolution): bool
    {
        return $user->can('update', $resolution) && 
               $resolution->propose_par === $user->id;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Resolution $resolution): bool
    {
        return $user->can('delete', $resolution) && 
               $resolution->propose_par === $user->id;
    }

    /**
     * Determine whether the user can accept the resolution.
     */
    public function accept(User $user, Resolution $resolution): bool
    {
        // Only the complainant can accept the resolution
        return $resolution->plainte->plaignant_id === $user->id &&
               $resolution->statut === 'en_attente';
    }

    /**
     * Determine whether the user can reject the resolution.
     */
    public function reject(User $user, Resolution $resolution): bool
    {
        // Only the complainant can reject the resolution
        return $resolution->plainte->plaignant_id === $user->id &&
               $resolution->statut === 'en_attente';
    }
}