<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appels', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plainte_id')->constrained('plaintes');
            $table->foreignId('appellant_id')->constrained('plaignants');
            
            $table->text('motif_appel');
            $table->datetime('date_appel');
            $table->datetime('date_limite')->nullable(); // 7 jours après première décision
            
            $table->enum('statut', ['en_cours', 'accepte', 'rejete'])->default('en_cours');
            $table->text('decision_appel')->nullable();
            $table->datetime('date_decision_appel')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('complaint_appeals');
    }
};
