<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('communications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plainte_id')->constrained('plaintes');
            $table->foreignId('sent_by')->constrained('users');
            
            $table->enum('type', ['accuse_reception', 'demande_info', 'notification_decision', 'suivi']);
            $table->enum('canal', ['email', 'telephone', 'courrier', 'sms', 'whatsapp']);
            $table->text('message');
            $table->datetime('date_envoi')->nullable();
            $table->boolean('recu_confirmation')->default(false);
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('communications');
    }
};
