<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('resolutions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plainte_id')->constrained('plaintes');
            $table->text('resolution')->nullable();
            $table->string('statut', 20)->default('en_attente');
            $table->timestamp('date_proposition')->nullable();
            $table->timestamp('date_validation')->nullable();
            $table->text('commentaire')->nullable();
            $table->foreignId('propose_par')->nullable()->constrained('users');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('resolutions');
    }

};
