<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ComplaintSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Créer des plaignants fictifs
        $plaignants = Plaignant::factory(50)->create();
        
        // Créer des plaintes avec différents statuts
        foreach ($plaignants as $plaignant) {
            Plainte::factory()
                ->for($plaignant)
                ->create([
                    'statut' => fake()->randomElement([
                        'recu', 'en_examen', 'recevable', 'en_enquete', 'resolu', 'clos'
                    ]),
                    'type_plainte' => fake()->randomElement(['sociale', 'environnementale', 'genre']),
                    'niveau_sensibilite' => fake()->randomElement(['sensible', 'non_sensible']),
                    'date_reception' => fake()->dateTimeBetween('-6 months', 'now'),
                ]);
        }
    }
}
