<?php

// ============================================================================
// CONTROLLERS ADDITIONNELS
// ============================================================================

// app/Http/Controllers/ComplaintInvestigationController.php


// app/Http/Controllers/ComplaintAppealController.php


// app/Http/Controllers/ReportController.php


// ============================================================================
// SERVICES
// ============================================================================

// app/Services/ComplaintNotificationService.php
class ComplaintNotificationService
{
    public function sendAccuseReception(Plainte $plainte)
    {
        if (!$plainte->plaignant->email && !$plainte->plaignant->telephone) {
            return false;
        }

        $message = $this->buildAccuseReceptionMessage($plainte);
        
        if ($plainte->plaignant->email) {
            // Envoyer par email
            Mail::to($plainte->plaignant->email)
                ->send(new AccuseReceptionMail($plainte, $message));
        }

        if ($plainte->plaignant->telephone) {
            // Envoyer par SMS (intégration avec service SMS)
            $this->sendSMS($plainte->plaignant->telephone, $message);
        }

        return true;
    }

    public function notifyStatusChange(Plainte $plainte, string $previousStatus)
    {
        $message = $this->buildStatusChangeMessage($plainte, $previousStatus);
        
        ComplaintCommunication::create([
            'complaint_id' => $plainte->id,
            'sent_by' => auth()->id(),
            'type' => 'notification_decision',
            'canal' => $plainte->plaignant->email ? 'email' : 'telephone',
            'message' => $message,
            'date_envoi' => now(),
        ]);

        // Envoyer la notification
        if ($plainte->plaignant->email) {
            Mail::to($plainte->plaignant->email)
                ->send(new StatusChangeMail($plainte, $message));
        }
    }

    private function buildAccuseReceptionMessage(Plainte $plainte): string
    {
        return "Cher(e) {$plainte->plaignant->nom},\n\n" .
               "Nous accusons réception de votre plainte numéro {$plainte->numero} " .
               "déposée le {$plainte->date_reception->format('d/m/Y à H:i')}.\n\n" .
               "Objet: {$plainte->objet}\n\n" .
               "Votre plainte est en cours d'examen. Nous vous tiendrons informé(e) " .
               "de l'évolution du traitement.\n\n" .
               "Cordialement,\nÉquipe FIE";
    }

    private function buildStatusChangeMessage(Plainte $plainte, string $previousStatus): string
    {
        $statusLabels = [
            'recu' => 'Reçu',
            'en_examen' => 'En cours d\'examen',
            'recevable' => 'Recevable',
            'irrecevable' => 'Irrecevable',
            'en_enquete' => 'En cours d\'enquête',
            'resolu' => 'Résolu',
            'en_appel' => 'En appel',
            'clos' => 'Clos'
        ];

        return "Cher(e) {$plainte->plaignant->nom},\n\n" .
               "Le statut de votre plainte {$plainte->numero} a évolué:\n" .
               "Ancien statut: {$statusLabels[$previousStatus]}\n" .
               "Nouveau statut: {$statusLabels[$plainte->statut]}\n\n" .
               ($plainte->decision ? "Décision: {$plainte->decision}\n\n" : '') .
               "Cordialement,\nÉquipe FIE";
    }

    private function sendSMS(string $phone, string $message)
    {
        // Intégration avec un service SMS (Orange Money, etc.)
        // Exemple avec une API fictive
        /*
        Http::post('https://sms-api.example.com/send', [
            'to' => $phone,
            'message' => $message,
            'api_key' => config('services.sms.api_key')
        ]);
        */
    }
}

// ============================================================================
// JOBS POUR TRAITEMENT ASYNCHRONE
// ============================================================================

// app/Jobs/ProcessComplaintJob.php


// ============================================================================
// COMMAND ARTISAN
// ============================================================================

// app/Console/Commands/CheckComplaintDeadlines.php


// ============================================================================
// ROUTES
// ============================================================================

// routes/web.php


// ============================================================================
// MAIL CLASSES
// ============================================================================

// app/Mail/AccuseReceptionMail.php


// resources/views/emails/accuse-reception.blade.php


// ============================================================================
// CONFIGURATION ADDITIONNELLE
// ============================================================================

// config/plaintes.php

// ============================================================================
// SEEDERS POUR DONNÉES DE TEST
// ============================================================================

// database/seeders/ComplaintSeeder.php

