@extends('layouts.app')

@section('title', 'Journaux d\'activité')

@push('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Journal des activités</h3>
                </div>

                <div class="card-body">
                    <!-- Filters -->
                    <form method="GET" action="{{ route('activity-logs.index') }}" class="mb-4">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control" 
                                           placeholder="Rechercher..." 
                                           value="{{ request('search') }}">
                                    <button class="btn btn-outline-secondary" type="submit">
                                        <i class="bi bi-search"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-8"></div>

                            <!-- User Filter -->
                            <div class="col-md-4">
                                <select name="user_id" class="form-select">
                                    <option value="">Tous les utilisateurs</option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>
                                            {{ $user->fullname }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Model Type Filter -->
                            <div class="col-md-3">
                                <select name="subject_type" class="form-select">
                                    <option value="">Tous les modèles</option>
                                    @foreach($modelTypes as $type => $label)
                                        <option value="{{ $type }}" {{ request('subject_type') == $type ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Date Range -->
                            <div class="col-md-3">
                                <input type="text" name="date_range" id="date-range" class="form-control" 
                                       placeholder="Sélectionner une période"
                                       value="{{ request('date_range') }}">
                            </div>

                            <!-- Action Buttons -->
                            <div class="col-md-1">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-funnel"></i>
                                </button>
                            </div>
                            @if(request()->hasAny(['search', 'user_id', 'subject_type', 'date_range']))
                            <div class="col-md-1">
                                <a href="{{ route('activity-logs.index') }}" class="btn btn-secondary w-100">
                                    <i class="bi bi-x-lg"></i>
                                </a>
                            </div>
                            @endif
                        </div>
                    </form>

                    <!-- Activity Logs Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th>Description</th>
                                    <th>Utilisateur</th>
                                    <th>Modèle</th>
                                    <th>Date</th>
                                    <th width="15%">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($activities as $activity)
                                    <tr>
                                        <td>{{ $loop->iteration + (($activities->currentPage() - 1) * $activities->perPage()) }}</td>
                                        <td>{{ $activity->description }}</td>
                                        <td>{{ $activity->causer->name ?? 'Système' }}</td>
                                        <td>
                                            @if($activity->subject_type)
                                                {{ class_basename($activity->subject_type) }}
                                                @if($activity->subject_id)
                                                    #{{ $activity->subject_id }}
                                                @endif
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>{{ $activity->created_at->format('d/m/Y H:i') }}</td>
                                        <td>
                                            <a href="{{ route('activity-logs.show', $activity->id) }}" 
                                               class="btn btn-sm btn-info"
                                               data-bs-toggle="tooltip" 
                                               title="Voir les détails">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center">Aucune activité à afficher.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            Affichage de {{ $activities->firstItem() ?? 0 }} à {{ $activities->lastItem() ?? 0 }} sur {{ $activities->total() }} entrées
                        </div>
                        <div>
                            {{ $activities->appends(request()->query())->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://npmcdn.com/flatpickr/dist/l10n/fr.js"></script>
<script>
    // Initialize date range picker
    document.addEventListener('DOMContentLoaded', function() {
        // Date range picker
        flatpickr("#date-range", {
            mode: "range",
            dateFormat: "Y-m-d",
            locale: "fr",
            allowInput: true
        });

        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
@endpush