@extends('layouts.app')

@section('title', 'Détails du journal d\'activité')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Détails de l'activité</h3>
                    <a href="{{ route('activity-logs.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left"></i> Retour
                    </a>
                </div>

                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Informations générales</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table">
                                        <tr>
                                            <th width="40%">Description:</th>
                                            <td>{{ $activity->description }}</td>
                                        </tr>
                                        <tr>
                                            <th>Utilisateur:</th>
                                            <td>{{ $activity->causer->fullname ?? 'Système' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Date:</th>
                                            <td>{{ $activity->created_at->format('d/m/Y H:i:s') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Modèle concerné:</th>
                                            <td>
                                                @if($activity->subject)
                                                    {{ class_basename($activity->subject_type) }} #{{ $activity->subject_id }}
                                                @else
                                                    N/A
                                                @endif
                                                @if($activity->subject_type == 'App\Models\Plaignant')
                                                    <a href="{{ route('plaignants.show', $activity->subject_id) }}" class="btn btn-secondary float-end btn-sm">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                @elseif($activity->subject_type == 'App\Models\Plainte')
                                                    <a href="{{ route('plaintes.show', $activity->subject_id) }}" class="btn btn-secondary float-end btn-sm">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                @elseif($activity->subject_type == 'App\Models\Financement')
                                                    <a href="{{ route('financements.show', $activity->subject_id) }}" class="btn btn-secondary float-end btn-sm">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Détails techniques</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table">
                                        <tr>
                                            <th width="40%">ID de l'événement:</th>
                                            <td>{{ $activity->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>Type d'événement:</th>
                                            <td>{{ $activity->event }}</td>
                                        </tr>
                                        <tr>
                                            <th>Adresse IP:</th>
                                            <td>{{ $activity->properties->get('ip_address') ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>User Agent:</th>
                                            <td>{{ $activity->properties->get('user_agent') ?? 'N/A' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($activity->properties->has('attributes'))
                        <div class="card">
                            <div class="card-header">
                                <h5>Modifications effectuées</h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Champ</th>
                                                <th>Ancienne valeur</th>
                                                <th>Nouvelle valeur</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($activity->properties->get('attributes', []) as $key => $value)
                                                @if(!in_array($key, ['updated_at', 'created_at']))
                                                    <tr>
                                                        <td><strong>{{ $key }}</strong></td>
                                                        <td>
                                                            @if(is_array($activity->properties->get('old', [])[$key] ?? null))
                                                                <pre class="mb-0">{{ json_encode($activity->properties->get('old', [])[$key], JSON_PRETTY_PRINT) }}</pre>
                                                            @else
                                                                {{ $activity->properties->get('old', [])[$key] ?? 'N/A' }}
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if(is_array($value))
                                                                <pre class="mb-0">{{ json_encode($value, JSON_PRETTY_PRINT) }}</pre>
                                                            @else
                                                                {{ $value }}
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="card-footer">
                    <a href="{{ route('activity-logs.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left"></i> Retour à la liste
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
