@extends('layouts.app')

@section('title', 'Modifier Configuration')

@section('content')
<div class="page-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Modifier Configuration</h4>
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Tableau de bord</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('configurations.index') }}">Configurations</a></li>
                            <li class="breadcrumb-item active">Modifier</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Modifier la configuration: <code>{{ $configuration->key }}</code></h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('configurations.update', $configuration) }}" method="POST">
                            @csrf
                            @method('PUT')
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="key" class="form-label">Clé <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('key') is-invalid @enderror" 
                                               id="key" name="key" value="{{ old('key', $configuration->key) }}" required>
                                        @error('key')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <div class="form-text">Identifiant unique de la configuration</div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="type" class="form-label">Type <span class="text-danger">*</span></label>
                                        <select class="form-select @error('type') is-invalid @enderror" 
                                                id="type" name="type" required>
                                            @foreach($types as $type)
                                                <option value="{{ $type }}" 
                                                        {{ old('type', $configuration->type) == $type ? 'selected' : '' }}>
                                                    {{ ucfirst($type) }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('type')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="value" class="form-label">Valeur <span class="text-danger">*</span></label>
                                @if($configuration->type === 'boolean')
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="value" name="value" 
                                               {{ old('value', $configuration->value) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="value">
                                            Activé
                                        </label>
                                    </div>
                                @else
                                    <textarea class="form-control @error('value') is-invalid @enderror" 
                                              id="value" name="value" rows="3" required>{{ old('value', $configuration->value) }}</textarea>
                                @endif
                                @error('value')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text" id="value-help">
                                    Valeur de la configuration
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="group" class="form-label">Groupe <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('group') is-invalid @enderror" 
                                               id="group" name="group" value="{{ old('group', $configuration->group) }}" required>
                                        @error('group')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <div class="form-text">Groupe d'organisation</div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="description" class="form-label">Description</label>
                                        <input type="text" class="form-control @error('description') is-invalid @enderror" 
                                               id="description" name="description" value="{{ old('description', $configuration->description) }}">
                                        @error('description')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="is_public" name="is_public" 
                                           {{ old('is_public', $configuration->is_public) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_public">
                                        Configuration publique
                                    </label>
                                    <div class="form-text">Les configurations publiques peuvent être exposées via l'API</div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end gap-2">
                                <a href="{{ route('configurations.index') }}" class="btn btn-secondary">
                                    <i class="ri-arrow-left-line me-1"></i> Annuler
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="ri-save-line me-1"></i> Mettre à jour
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('type').addEventListener('change', function() {
    const type = this.value;
    const valueInput = document.getElementById('value');
    const valueHelp = document.getElementById('value-help');
    
    switch(type) {
        case 'boolean':
            valueInput.type = 'checkbox';
            valueInput.rows = null;
            valueHelp.textContent = 'Cochez pour activer (true), décochez pour désactiver (false)';
            break;
        case 'integer':
            valueInput.type = 'number';
            valueInput.rows = null;
            valueHelp.textContent = 'Entrez un nombre entier';
            break;
        case 'json':
            valueInput.type = 'textarea';
            valueInput.rows = 5;
            valueHelp.pwetextContent = 'Entrez un objet JSON valide (ex: {"key": "value"})';
            break;
        default:
            valueInput.type = 'textarea';
            valueInput.rows = 3;
            valueHelp.textContent = 'Valeur de la configuration';
    }
});
</script>
@endsection