@extends('layouts.app')

@section('title', 'Configurations')

@section('content')
<div class="page-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Gestion des Configurations</h4>
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Tableau de bord</a></li>
                            <li class="breadcrumb-item active">Configurations</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="card-title mb-0">Liste des Configurations</h4>
                            {{-- @can('config//-create') --}}
                            <a href="{{ route('configurations.create') }}" class="btn btn-primary">
                                <i class="bi bi-plus-circle me-1"></i> Nouvelle Configuration
                            </a>
                            {{-- @endcan --}}
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Filtres -->
                        <form method="GET" class="row g-3 mb-4">
                            <div class="col-md-3">
                                <input type="text" class="form-control" name="search" placeholder="Rechercher..." 
                                       value="{{ request('search') }}">
                            </div>
                            <div class="col-md-2">
                                <select name="group" class="form-select">
                                    <option value="">Tous les groupes</option>
                                    @foreach($groups as $group)
                                        <option value="{{ $group }}" {{ request('group') == $group ? 'selected' : '' }}>
                                            {{ ucfirst($group) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="type" class="form-select">
                                    <option value="">Tous les types</option>
                                    @foreach($types as $type)
                                        <option value="{{ $type }}" {{ request('type') == $type ? 'selected' : '' }}>
                                            {{ ucfirst($type) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="ri-search-line"></i> Filtrer
                                </button>
                            </div>
                            <div class="col-md-2">
                                <a href="{{ route('configurations.index') }}" class="btn btn-outline-secondary">
                                    <i class="ri-refresh-line"></i> Réinitialiser
                                </a>
                            </div>
                        </form>

                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>Clé</th>
                                        <th>Valeur</th>
                                        <th>Type</th>
                                        <th>Groupe</th>
                                        <th>Description</th>
                                        <th>Public</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($configurations as $config)
                                    <tr>
                                        <td>
                                            <code>{{ $config->key }}</code>
                                        </td>
                                        <td>
                                            @if($config->type === 'json')
                                                <pre class="mb-0"><code>{{ $config->value }}</code></pre>
                                            @elseif($config->type === 'boolean')
                                                <span class="badge bg-{{ $config->value ? 'success' : 'danger' }}">
                                                    {{ $config->value ? 'Oui' : 'Non' }}
                                                </span>
                                            @else
                                                {{ Str::limit($config->value, 50) }}
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ $config->type }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary">{{ $config->group }}</span>
                                        </td>
                                        <td>{{ $config->description }}</td>
                                        <td>
                                            @if($config->is_public)
                                                <span class="badge bg-success">Oui</span>
                                            @else
                                                <span class="badge bg-warning">Non</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                {{-- @can('config-edit') --}}
                                                <a href="{{ route('configurations.edit', $config) }}" 
                                                   class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                {{-- @endcan --}}
                                                {{-- @can('config-delete') --}}
                                                <form action="{{ route('configurations.destroy', $config) }}" 
                                                      method="POST" class="d-inline"
                                                      onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cette configuration ?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </form>
                                                {{-- @endcan --}}
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted">
                                            Aucune configuration trouvée
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-center">
                            {{ $configurations->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection