{{-- resources/views/admin/users/create.blade.php --}}
@extends('layouts.app')
@section('heading')
<div class="page-heading">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="{{ route('admin.dashboard') }}">Tableau de bord</a>
            </li>
            <li class="breadcrumb-item">
                <a href="{{ route('parametres.index') }}">Paramètres</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Créer</li>
        </ol>
    </nav>
    <h3>Créer un nouvel utilisateur
        <a href="{{ route('parametres.index') }}" class="btn btn-secondary float-end">
                        <i class="bi bi-arrow-left"></i> Retour
        </a>

    </h3>
</div>
@endsection
@section('content')
    <div class="card">

        <form method="POST" action="{{ route('parametres.store') }}">
            @csrf
            <div class="card-body">
                <!-- Informations de base -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="type" class="required">Type de paramètre</label>
                            <select class="form-control @error('type') is-invalid @enderror" 
                                id="type" 
                                name="type" 
                                required>
                                <option value="">Sélectionner un type</option>
                                @foreach($types as $key => $type)
                                <option value="{{ $key }}" 
                                    {{ old('type') == $key ? 'selected' : '' }}>
                                    {{ ucfirst($type) }}
                                </option>
                                @endforeach
                            </select>
                            @error('error')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="libelle_court" class="required">Libellé Court</label>
                            <input type="text" 
                                class="form-control @error('libelle_court') is-invalid @enderror" 
                                id="libelle_court" 
                            name="libelle_court" 
                            value="{{ old('libelle_court') }}" 
                            required>
                            @error('libelle_court')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="libelle_long" class="required">Libellé Long</label>
                            <input type="text" 
                                class="form-control @error('libelle_long') is-invalid @enderror" 
                                id="libelle_long" 
                            name="libelle_long" 
                            value="{{ old('libelle_long') }}" 
                            required>
                            @error('libelle_long')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="ordre" class="required">Numéro d'ordre</label>
                            <input type="number" 
                                class="form-control @error('ordre') is-invalid @enderror" 
                                id="ordre" 
                                name="ordre" 
                                value="{{ old('ordre') }}" 
                                required>
                            @error('ordre')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <div class="card-footer text-end">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Créer le paramètre
                </button>
                <a href="{{ route('parametres.index') }}" class="btn btn-secondary ml-2">
                    Annuler
                </a>
            </div>
        </form>
    </div>
@endsection

@push('styles')
<style>
.required:after {
    content: " *";
    color: red;
}
</style>
@endpush