
@extends('layouts.app')

@section('title', 'Gestion des paramètres')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Liste des Paramètres</h3>
                    {{-- @can('user-create') --}}
                    <a href="{{ route('parametres.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus"></i> Nouveau paramètre
                    </a>
                    {{-- @endcan --}}
                </div>

                <div class="card-body">
                    <!-- Filtres -->
                    <form method="GET" action="{{ route('parametres.index') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <input type="text" name="search" class="form-control" 
                                       placeholder="Rechercher par libellé..." 
                                       value="{{ request('search') }}">
                            </div>
                            <div class="col-md-3">
                                <select name="type" class="form-control">
                                    <option value="">Tous les types</option>
                                    @foreach($types as $type)
                                    <option value="{{ $type }}" 
                                            {{ request('type') == $type ? 'selected' : '' }}>
                                        {{ ucfirst($type) }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="bi bi-search"></i> Filtrer
                                </button>
                                <a href="{{ route('parametres.index') }}" class="btn btn-outline-danger ml-1">
                                    <i class="bi bi-x-lg"></i>
                                </a>
                            </div>
                        </div>
                    </form>

                    <!-- Table des utilisateurs -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">ID</th>
                                    <th>Libelle Court</th>
                                    <th>Libellé Long</th>
                                    <th>Ordre</th>
                                    <th>Type</th>
                                    <th width="15%">Date de création</th>
                                    <th width="15%">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($parametres as $parametre)
                                <tr>
                                    <td>{{ $parametre->id }}</td>
                                    <td>
                                        <strong>{{ $parametre->libelle_court }}</strong>
                                    </td>
                                    <td>{{ $parametre->libelle_long }}</td>
                                    <td>{{ $parametre->ordre }}</td>
                                    <td>{{ $parametre->type }}</td>
                                    <td>{{ $parametre->created_at->format('d/m/Y H:i') }}</td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('parametres.show', $parametre) }}" 
                                               class="btn btn-info" title="Voir">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            @can('user-edit')
                                            <a href="{{ route('parametres.edit', $parametre) }}" 
                                               class="btn btn-warning" title="Modifier">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            @endcan

                                            @can('user-delete')
                                            <form method="POST"
                                                  action="{{ route('parametres.destroy', $parametre) }}"
                                                  style="display: inline-block;"
                                                  onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce paramètre ?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger" title="Supprimer">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">
                                        <em>Aucun utilisateur trouvé.</em>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            Affichage de {{ $parametres->firstItem() ?? 0 }} à {{ $parametres->lastItem() ?? 0 }} 
                            sur {{ $parametres->total() }} paramètres
                        </div>
                        {{ $parametres->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Auto-submit form on select change
    document.querySelectorAll('select[name="role"], select[name="status"]').forEach(function(select) {
        select.addEventListener('change', function() {
            this.form.submit();
        });
    });
</script>
@endpush