{{-- resources/views/admin/users/create.blade.php --}}
@extends('layouts.app')


@section('heading')
<div class="page-heading">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="{{ route('admin.dashboard') }}">Tableau de bord</a>
            </li>
            <li class="breadcrumb-item">
                <a href="{{ route('users.index') }}">Utilisateurs</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Créer</li>
        </ol>
    </nav>
    <h3>Créer un nouvel utilisateur
        <a href="{{ route('users.index') }}" class="btn btn-secondary float-end">
                        <i class="bi bi-arrow-left"></i> Retour
        </a>

    </h3>
</div>
@endsection
@section('content')
    <div class="card">

        <form method="POST" action="{{ route('users.store') }}">
            @csrf
            <div class="card-body">
                <!-- Informations de base -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="nom" class="required">Nom</label>
                            <input type="text" 
                                class="form-control @error('nom') is-invalid @enderror" 
                                id="nom" 
                            name="nom" 
                            value="{{ old('nom') }}" 
                            required>
                            @error('nom')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="prenom" class="required">Prénom</label>
                            <input type="text" 
                                class="form-control @error('prenom') is-invalid @enderror" 
                                id="prenom" 
                                name="prenom" 
                                value="{{ old('prenom') }}" 
                                required>
                            @error('prenom')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    {{-- <div class="col-md-6">
                        <div class="form-group">
                            <label for="genre" class="required">Genre</label>
                            <select class="form-control @error('genre') is-invalid @enderror" 
                                id="genre" 
                                name="genre" 
                                required>
                                <option value="" disabled {{ old('genre') ? '' : 'selected' }}>Sélectionnez le genre</option>
                                <option value="Masculin" {{ old('genre') == 'Masculin' ? 'selected' : '' }}>Masculin</option>
                                <option value="Féminin" {{ old('genre') == 'Féminin' ? 'selected' : '' }}>Féminin</option>
                                <option value="Autre" {{ old('genre') == 'Autre' ? 'selected' : '' }}>Autre</option>
                            </select>
                            @error('genre')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="telephone" class="required">Téléphone</label>
                            <input type="text" 
                                class="form-control @error('telephone') is-invalid @enderror" 
                                id="telephone" 
                                name="telephone" 
                                value="{{ old('telephone') }}" 
                                required>
                            @error('telephone')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="matricule" class="required">Matricule</label>
                            <input type="text" 
                                class="form-control @error('matricule') is-invalid @enderror" 
                                id="matricule" 
                                name="matricule" 
                                value="{{ old('matricule') }}" 
                                required>
                            @error('matricule')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="fonction" class="required">Fonction</label>
                            <input type="text" 
                                class="form-control @error('fonction') is-invalid @enderror" 
                                id="fonction" 
                                name="fonction" 
                                value="{{ old('fonction') }}" 
                                required>
                            @error('fonction')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div> --}}
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="email" class="required">Adresse email</label>
                            <input type="email" 
                                class="form-control @error('email') is-invalid @enderror" 
                                id="email" 
                                name="email" 
                                value="{{ old('email') }}" 
                                required>
                            @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row col-md-12">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="password" class="required">Mot de passe</label>
                                <input type="password" 
                                    class="form-control @error('password') is-invalid @enderror" 
                                    id="password" 
                                    name="password" 
                                    required>
                                @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="password_confirmation" class="required">Confirmer le mot de passe</label>
                                <input type="password" 
                                    class="form-control" 
                                    id="password_confirmation" 
                                    name="password_confirmation" 
                                    required>
                            </div>
                        </div>
                    </div>

                    <!-- Rôles -->
                    <div class="form-group col-md-12">
                        <label>Rôles</label>
                        <div class="row">
                            @foreach($roles as $role)
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input type="checkbox" 
                                        class="form-check-input" 
                                        id="role_{{ $role->id }}" 
                                        name="roles[]" 
                                        value="{{ $role->name }}"
                                        {{ in_array($role->name, old('roles', [])) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="role_{{ $role->id }}">
                                        {{ ucfirst($role->name) }}
                                    </label>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @error('roles')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Statut -->
                    <div class="col-md-12">
                        <div class="form-group">
                            <div class="form-check">
                                <input type="checkbox" 
                                    class="form-check-input" 
                                    id="is_active" 
                                    name="is_active" 
                                    value="1"
                                    {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Compte actif
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card-footer text-end">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Créer l'utilisateur
                </button>
                <a href="{{ route('users.index') }}" class="btn btn-secondary ml-2">
                    Annuler
                </a>
            </div>
        </form>
    </div>
@endsection

@push('styles')
<style>
.required:after {
    content: " *";
    color: red;
}
</style>
@endpush