{{-- resources/views/admin/users/show.blade.php --}}
@extends('layouts.app')

@section('title', 'Profil Utilisateur')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Profil de {{ $user->name }}</h3>
                    <div>
                        @can('user-edit')
                        <a href="{{ route('users.edit', $user) }}" class="btn btn-warning">
                            <i class="bi bi-edit"></i> Modifier
                        </a>
                        @endcan
                        <a href="{{ route('users.index') }}" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Retour
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Informations personnelles -->
                        <div class="col-md-6">
                            <h5 class="border-bottom pb-2 mb-3">Informations personnelles</h5>
                            
                            <div class="mb-3">
                                <strong>Nom complet :</strong><br>
                                <span class="text-muted">{{ $user->name }}</span>
                            </div>

                            <div class="mb-3">
                                <strong>Adresse email :</strong><br>
                                <span class="text-muted">{{ $user->email }}</span>
                            </div>

                            <div class="mb-3">
                                <strong>Statut du compte :</strong><br>
                                @if($user->is_active)
                                <span class="badge badge-success">Actif</span>
                                @else
                                <span class="badge badge-danger">Inactif</span>
                                @endif
                            </div>

                            <div class="mb-3">
                                <strong>Date de création :</strong><br>
                                <span class="text-muted">{{ $user->created_at->format('d/m/Y à H:i') }}</span>
                            </div>

                            <div class="mb-3">
                                <strong>Dernière modification :</strong><br>
                                <span class="text-muted">{{ $user->updated_at->format('d/m/Y à H:i') }}</span>
                            </div>
                        </div>

                        <!-- Rôles et permissions -->
                        <div class="col-md-6">
                            <h5 class="border-bottom pb-2 mb-3">Rôles et Permissions</h5>
                            
                            <div class="mb-3">
                                <strong>Rôles assignés :</strong><br>
                                @forelse($user->roles as $role)
                                <span class="badge badge-secondary mr-1 mb-1">
                                    {{ ucfirst($role->name) }}
                                </span>
                                @empty
                                <span class="text-muted">Aucun rôle assigné</span>
                                @endforelse
                            </div>

                            <div class="mb-3">
                                <strong>Permissions :</strong><br>
                                @php
                                    $permissions = $user->getAllPermissions();
                                @endphp
                                @if($permissions->count() > 0)
                                <div class="row">
                                    @foreach($permissions as $permission)
                                    <div class="col-12 mb-1">
                                        <small class="badge badge-light">
                                            {{ $permission->name }}
                                        </small>
                                    </div>
                                    @endforeach
                                </div>
                                @else
                                <span class="text-muted">Aucune permission</span>
                                @endif
                            </div>
                        </div>
                    </div>

                    @if($user->id == auth()->id())
                    <div class="alert alert-info mt-3">
                        <i class="bi bi-user"></i>
                        <strong>C'est votre profil !</strong> 
                        Vous consultez vos propres informations.
                    </div>
                    @endif
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-between">
                        <div>
                            @can('user-edit')
                            <a href="{{ route('users.edit', $user) }}" class="btn btn-warning">
                                <i class="bi bi-edit"></i> Modifier cet utilisateur
                            </a>
                            @endcan
                        </div>
                        <div>
                            @can('user-delete')
                            @if($user->id != auth()->id())
                            <form method="POST" 
                                  action="{{ route('users.destroy', $user) }}" 
                                  style="display: inline-block;"
                                  onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cet utilisateur ? Cette action est irréversible.')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">
                                    <i class="bi bi-trash"></i> Supprimer cet utilisateur
                                </button>
                            </form>
                            @endif
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection