<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Proposition de résolution - Plainte n°{{ $plainte->numero }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body, html {
            margin: 0;
            padding: 0;
            font-family: 'Nunito', Arial, sans-serif;
            line-height: 1.6;
            color: #333333;
            background-color: #f4f4f4;
            -webkit-font-smoothing: antialiased;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .email-header {
            background-color: #1a365d;
            padding: 25px 30px;
            text-align: center;
            border-bottom: 5px solid #e2a03f;
        }
        
        .email-logo {
            max-width: 180px;
            height: auto;
        }
        
        .email-body {
            padding: 30px;
        }
        
        .email-footer {
            background-color: #f8f9fa;
            padding: 20px 30px;
            text-align: center;
            font-size: 13px;
            color: #6c757d;
            border-top: 1px solid #e9ecef;
        }
        
        h1, h2, h3, h4 {
            color: #1a365d;
            margin-top: 0;
            font-weight: 700;
        }
        
        h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        
        p {
            margin: 0 0 15px 0;
            font-size: 16px;
            color: #4a5568;
        }
        
        .card {
            background: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .card-title {
            font-size: 16px;
            font-weight: 700;
            color: #1a365d;
            margin: 0 0 15px 0;
            padding-bottom: 10px;
            border-bottom: 1px solid #e2e8f0;
        }
        
        .status-badge {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 4px;
            font-size: 14px;
            font-weight: 600;
            text-transform: capitalize;
            margin-bottom: 20px;
            background-color: #3182ce;
            color: white;
        }
        
        .btn {
            display: inline-block;
            background-color: #3182ce;
            color: white !important;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 4px;
            font-weight: 600;
            margin: 5px;
            text-align: center;
        }
        
        .btn-accept {
            background-color: #38a169;
        }
        
        .btn-reject {
            background-color: #e53e3e;
        }
        
        .btn-container {
            margin: 20px 0;
            text-align: center;
        }
        
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                border-radius: 0;
            }
            
            .email-body, .email-footer {
                padding: 20px 15px !important;
            }
            
            .btn {
                display: block;
                width: 100%;
                margin: 10px 0;
            }
        }
    </style>
</head>
<body style="margin: 0; padding: 0; font-family: 'Nunito', Arial, sans-serif; background-color: #f4f4f4;">
    <div class="email-container">
        <div class="email-header">
            <img src="{{ $message->embed(public_path('assets/images/fie.jpg')) }}" alt="FIE Logo" class="email-logo">
            <div style="color: #ffffff; font-size: 14px; margin-top: 10px;">Service de Gestion des Plaintes</div>
        </div>
        
        <div class="email-body">
            <h1>Proposition de résolution</h1>
            
            <p>Bonjour {{ $plainte->plaignant->nom ?? 'Madame, Monsieur' }},</p>
            
            <p>Nous vous informons qu'une proposition de résolution a été formulée pour votre plainte n°{{ $plainte->numero }}.</p>
            
            <div class="status-badge">Résolution proposée</div>
            
            <div class="card">
                <h3 class="card-title">Détails de la plainte</h3>
                <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; width: 40%; color: #718096; font-weight: 600;">Numéro de plainte :</td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; color: #2d3748; font-weight: 600;">{{ $plainte->numero }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; color: #718096; font-weight: 600;">Date de dépôt :</td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; color: #2d3748;">{{ $plainte->created_at->format('d/m/Y à H:i') }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; color: #718096; font-weight: 600;">Objet :</td>
                        <td style="padding: 8px 0; color: #2d3748;">{{ $plainte->objet }}</td>
                    </tr>
                </table>
                
                <h4 style="color: #1a365d; margin: 20px 0 10px 0; font-size: 16px;">Proposition de résolution :</h4>
                <div style="background-color: #f0f9ff; padding: 15px; border-radius: 4px; border-left: 4px solid #3182ce; margin: 10px 0 20px 0;">
                    {!! nl2br(e($plainte->resolution_proposee)) !!}
                </div>
                <p style="margin: 20px 0 10px 0;">
                    Veuillez nous indiquer si cette proposition vous convient en cliquant sur l'un des boutons ci-dessous :
                </p>
                
                <div class="btn-container">
                    {{-- <a href="{{ route('plaintes.accepter-resolution', ['plainte' => $plainte->id, 'token' => $plainte->getResolutionToken()]) }}" class="btn btn-accept">
                        J'accepte cette résolution
                    </a>
                    <a href="{{ route('plaintes.refuser-resolution', ['plainte' => $plainte->id, 'token' => $plainte->getResolutionToken()]) }}" class="btn btn-reject">
                        Je refuse cette résolution
                    </a> --}}
                </div>
                
                <p style="font-size: 13px; color: #718096; margin: 20px 0 0 0;">
                    <strong>Note :</strong> Si vous refusez la résolution, vous aurez la possibilité de fournir des commentaires supplémentaires.
                </p>
            </div>
            
            <div class="card" style="background-color: #fff5f5; border-color: #fed7d7;">
                <h4 style="color: #e53e3e; margin: 0 0 10px 0; font-size: 16px; font-weight: 600;">Important :</h4>
                <p style="margin: 0; color: #e53e3e;">
                    Vous disposez de 7 jours pour répondre à cette proposition. Passé ce délai, la plainte sera automatiquement clôturée avec cette résolution.
                </p>
            </div>
            
            <p style="margin: 25px 0 15px 0; color: #4a5568;">
                Nous restons à votre disposition pour toute information complémentaire,<br>
                <strong>L'équipe du Service des Plaintes FIE</strong>
            </p>
        </div>
        
        <div class="email-footer">
            <p style="margin: 0 0 10px 0;">
                <a href="{{ config('app.url') }}" style="color: #4a5568; text-decoration: none; font-weight: 600;">www.fie.bf</a>
                <span style="margin: 0 10px;">|</span>
                <a href="mailto:plaintes@fie.bf" style="color: #4a5568; text-decoration: none;">plaintes@fie.bf</a>
            </p>
            <p style="margin: 0 0 5px 0; font-size: 12px;">
                © {{ date('Y') }} FIE - Tous droits réservés
            </p>
            <p style="margin: 0; font-size: 11px; color: #a0aec0;">
                Ceci est un message automatique, merci de ne pas y répondre.
            </p>
        </div>
    </div>
</body>
</html>
