<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mise à jour du statut de votre plainte</title>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        /* Base Styles */
        body, html {
            margin: 0;
            padding: 0;
            font-family: 'Nunito', Arial, sans-serif;
            line-height: 1.6;
            color: #333333;
            background-color: #f4f4f4;
            -webkit-font-smoothing: antialiased;
        }
        
        /* Layout */
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .email-header {
            background-color: #1a365d;
            padding: 25px 30px;
            text-align: center;
            border-bottom: 5px solid #e2a03f;
        }
        
        .email-logo {
            max-width: 180px;
            height: auto;
        }
        
        .email-body {
            padding: 30px;
        }
        
        .email-footer {
            background-color: #f8f9fa;
            padding: 20px 30px;
            text-align: center;
            font-size: 13px;
            color: #6c757d;
            border-top: 1px solid #e9ecef;
        }
        
        /* Typography */
        h1, h2, h3, h4 {
            color: #1a365d;
            margin-top: 0;
            font-weight: 700;
        }
        
        h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        
        p {
            margin: 0 0 15px 0;
            font-size: 16px;
            color: #4a5568;
        }
        
        /* Card */
        .card {
            background: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .card-title {
            font-size: 16px;
            font-weight: 700;
            color: #1a365d;
            margin: 0 0 15px 0;
            padding-bottom: 10px;
            border-bottom: 1px solid #e2e8f0;
        }
        
        /* Button */
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background-color: #e2a03f;
            color: #ffffff !important;
            text-decoration: none;
            border-radius: 4px;
            font-weight: 600;
            text-align: center;
            margin: 20px 0;
        }
        
        /* Status Badge */
        .status-badge {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 4px;
            font-size: 14px;
            font-weight: 600;
            text-transform: capitalize;
            margin-bottom: 20px;
            color: white;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                border-radius: 0;
            }
            
            .email-body, .email-footer {
                padding: 20px 15px !important;
            }
            
            .btn {
                width: 100% !important;
                margin: 15px 0 !important;
            }
        }
    </style>
</head>
<body style="margin: 0; padding: 0; font-family: 'Nunito', Arial, sans-serif; background-color: #f4f4f4;">
    <div class="email-container">
        <!-- Header with Logo -->
        <div class="email-header">
            <img src="{{ $message->embed(public_path('assets/images/fie.jpg')) }}" alt="FIE Logo" class="email-logo">
            <div style="color: #ffffff; font-size: 14px; margin-top: 10px;">Service de Gestion des Plaintes</div>
        </div>
        
        <!-- Email Body -->
        <div class="email-body">
            <h1>Mise à jour du statut de votre plainte</h1>
            
            <p>Bonjour {{ $plainte->plaignant->nom }},</p>
            
            <p>Nous vous informons que le statut de votre plainte a été mis à jour.</p>
            
            <!-- Status Badge -->
            @php
                $statusMap = [
                    'recu' => ['label' => 'Reçu', 'color' => '#4299e1'],
                    'en_examen' => ['label' => 'En examen', 'color' => '#ecc94b'],
                    'recevable' => ['label' => 'Recevable', 'color' => '#48bb78'],
                    'irrecevable' => ['label' => 'Irrecevable', 'color' => '#f56565'],
                    'en_enquete' => ['label' => 'Enquête en cours', 'color' => '#9f7aea'],
                    'resolu' => ['label' => 'Résolu', 'color' => '#38b2ac'],
                    'clos' => ['label' => 'Clos', 'color' => '#718096']
                ];
                $status = $statusMap[$plainte->statut] ?? ['label' => $plainte->statut, 'color' => '#718096'];
            @endphp
            
            <div class="status-badge" style="background-color: {{ $status['color'] }}">
                {{ $status['label'] }}
            </div>
            
            <!-- Complaint Details Card -->
            <div class="card">
                <h3 class="card-title">Détails de la plainte</h3>
                <table style="width: 100%; border-collapse: collapse;">
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; width: 40%; color: #718096; font-weight: 600;">Numéro de plainte :</td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; color: #2d3748;">{{ $plainte->numero }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; color: #718096; font-weight: 600;">Objet :</td>
                        <td style="padding: 8px 0; border-bottom: 1px solid #edf2f7; color: #2d3748;">{{ $plainte->objet }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; color: #718096; font-weight: 600;">Date de réception :</td>
                        <td style="padding: 8px 0; color: #2d3748;">{{ $plainte->date_reception->format('d/m/Y à H:i') }}</td>
                    </tr>
                </table>
                
                @if($plainte->decision)
                <div style="margin-top: 15px; padding-top: 15px; border-top: 1px solid #e2e8f0;">
                    <h4 style="color: #1a365d; margin: 0 0 10px 0; font-size: 15px; font-weight: 600;">Décision :</h4>
                    <div style="background-color: #f8f9fa; padding: 12px; border-radius: 4px; border-left: 3px solid #e2a03f;">
                        <p style="margin: 0; color: #4a5568; font-style: italic;">{{ $plainte->decision }}</p>
                    </div>
                </div>
                @endif
            </div>
            
            @if(!empty($statusMessage))
            <div class="card">
                <h4 style="color: #1a365d; margin: 0 0 10px 0; font-size: 15px; font-weight: 600;">Message complémentaire :</h4>
                <div style="color: #4a5568; line-height: 1.6;">
                    {!! nl2br(e($statusMessage)) !!}
                </div>
            </div>
            @endif
            
            <!-- Action Button -->
            <div style="text-align: center; margin: 30px 0 20px 0;">
                <a href="{{ route('plaintes.suivi-plainte', ['reference' => $plainte->reference]) }}" class="btn">
                    Suivre ma plainte
                </a>
                <p style="font-size: 13px; color: #718096; margin: 10px 0 0 0;">
                    Vous pouvez suivre l'avancement de votre plainte en cliquant sur le bouton ci-dessus.
                </p>
            </div>
            
            <p style="margin: 25px 0 15px 0; color: #4a5568;">
                Cordialement,<br>
                <strong>L'équipe du Service des Plaintes FIE</strong>
            </p>
        </div>
        
        <!-- Footer -->
        <div class="email-footer">
            <p style="margin: 0 0 10px 0;">
                <a href="{{ config('app.url') }}" style="color: #4a5568; text-decoration: none; font-weight: 600;">www.fie.bf</a>
                <span style="margin: 0 10px;">|</span>
                <a href="mailto:contact@fie.bf" style="color: #4a5568; text-decoration: none;">contact@fie.bf</a>
            </p>
            <p style="margin: 0 0 5px 0; font-size: 12px;">
                © {{ date('Y') }} FIE - Tous droits réservés
            </p>
            <p style="margin: 0; font-size: 11px; color: #a0aec0;">
                Si vous n'êtes pas à l'origine de cette demande, veuillez ignorer cet email.
            </p>
        </div>
    </div>
</body>
</html>
