<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Export des Demandes de Financement</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .date-export {
            text-align: right;
            color: #666;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 10px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Liste des Demandes de Financement</h1>
    </div>
    
    <div class="date-export">
        Exporté le: {{ now()->format('d/m/Y H:i') }}
    </div>
    
    <table>
        <thead>
            <tr>
                <th>Référence</th>
                <th>Structure</th>
                <th>Personne habilitée</th>
                <th>Email</th>
                <th>Téléphone</th>
                <th>Projet</th>
                <th>Montant</th>
                <th>Statut</th>
            </tr>
        </thead>
        <tbody>
            @foreach($financements as $financement)
            <tr>
                <td>{{ $financement->reference }}</td>
                <td>{{ $financement->nom_structure }}</td>
                <td>{{ $financement->personne_habilitee }}</td>
                <td>{{ $financement->email }}</td>
                <td>{{ $financement->telephone }}</td>
                <td>{{ $financement->titre_projet }}</td>
                <td>{{ number_format($financement->montant_sollicite, 0, ',', ' ') }} FCFA</td>
                <td>{{ ucfirst($financement->statut) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    
    <div class="footer">
        <p>Généré par le système de gestion des demandes de financement - {{ config('app.name') }}</p>
    </div>
</body>
</html>
