<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Export des Plaintes</title>
    <style>
        @page {
            margin: 10px 25px;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 0;
        }
        .header {
            /* position: ;
            top: -80px;
            left: 0;
            right: 0;
            height: 80px;
            border-bottom: 1px solid #ddd;
            padding: 10px 0;
            margin-bottom: 20px; */
        }
        .header-table {
            align-items: start;
            /* Align the text to the top */
            vertical-align: top;
        }
        .logo {
            width: 60px;
            height: 60px;
        }
        .header-text {
            text-align: center;
            flex-grow: 1;
        }
        .header-text h1 {
            margin: 0;
            font-size: 16px;
            font-weight: bold;
            color: #333;
            text-transform: uppercase;
        }
        .header-text {
            font-size: 2rem;
            text-align: center;
        }
        .header-text p {
            margin: 5px 0 0;
            font-size: 10px;
            color: #666;
        }
        .header-content {
            font-size: 1.5rem;
            text-align: center;
        }
        .contact-info {
            text-align: left;
            font-size: 10px;
            line-height: 1.3;
        }
        .date-export {
            text-align: right;
            color: #666;
            margin: 60px 0 10px;
            font-size: 10px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 10px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="header">
        <table class="header-table">
            <tr>
                
                <td  style="width: 40%;">
                    <div class="header-text">
                        <h1>MINISTÈRE DE L’ENVIRONNEMENT DE L’EAU ET DE L’ASSAINISSEMENT</h1>
                        <h1>*****</h1>
                        <h1>SECRETARIAT GENERAL</h1>
                        <h1>*****</h1>
                        <h1>FONDS D’INTERVENTION POUR L’ENVIRONNEMENT</h1>
                    </div>
                </td>
                <td style="width: 30%;">
                    <img src="{{ public_path('assets/images/fie.jpg') }}" alt="Logo" style="max-width: 100%; max-height: 100px;">
                </td>
                <td style="width: 30%;">
                    <div class="contact-info">
                        <h1>Burkina Faso</h1>
                        <p>La Patrie ou la Mort, nous Vaincrons!</p>
                    </div>
                </td>
            </tr>
        </table>
    </div>
    <div class="header-content">
        <h2>LISTE DES PLAINTE</h2>
    </div>
    
    <div class="date-export">
        Exporté le: {{ now()->format('d/m/Y à H:i') }}
    </div>
    
    <table class="table">
        <thead>
            <tr>
                <th>Référence</th>
                <th>Date réception</th>
                <th>Objet</th>
                <th>Plaignant</th>
                <th>Email</th>
                <th>Téléphone</th>
                <th>Statut</th>
            </tr>
        </thead>
        <tbody>
            @foreach($plaintes as $plainte)
            <tr>
                <td>{{ $plainte->reference }}</td>
                <td>{{ $plainte->date_reception->format('d/m/Y') }}</td>
                <td>{{ $plainte->objet }}</td>
                <td>{{ $plainte->plaignant ? $plainte->plaignant->full_name : 'Anonyme' }}</td>
                <td>{{ $plainte->plaignant ? $plainte->plaignant->email : 'N/A' }}</td>
                <td>{{ $plainte->plaignant ? $plainte->plaignant->telephone : 'N/A' }}</td>
                <td>{{ ucfirst($plainte->statut) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    
    <div class="footer">
        <p>Généré par le système de gestion des plaintes - {{ config('app.name') }}</p>
    </div>
</body>
</html>
