@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h2>Gestion des Demandes de Financement - FIE 
                <a href="{{ route('financements.create') }}" class="btn btn-success btn-sm float-end">
                    <i class="bi bi-plus me-2"></i> Nouvelle Demande
                </a>
            </h2>
        </div>
    </div>

    <!-- Statistiques Dashboard -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5 class="text-white">{{ $stats['total'] ?? 0 }}</h5>
                    <p>Total Demandes</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <h5 class="text-white">{{ $stats['en_attente'] ?? 0 }}</h5>
                    <p>En Attente</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5 class="text-white">{{ $stats['approuve'] ?? 0 }}</h5>
                    <p>Approuvées</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5 class="text-white">{{ $stats['rejete'] ?? 0 }}</h5>
                    <p>Rejetées</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtres -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="py-2">
                <div class="float-center">
                    <a href="{{ route('exports.financements.excel') }}" class="btn btn-success">
                        <i class="bi bi-file-excel me-2"></i> Exporter en Excel
                    </a>
                    <a href="{{ route('exports.financements.pdf') }}" class="btn btn-danger">
                        <i class="bi bi-file-pdf me-2"></i> Exporter en PDF
                    </a>
                </div>
                <div class="clearfix"></div>
            </div>
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <select name="statut" class="form-select">
                        <option value="">Tous les statuts</option>
                        <option value="en_attente" {{ request('statut') == 'en_attente' ? 'selected' : '' }}>En Attente</option>
                        <option value="en_cours" {{ request('statut') == 'en_cours' ? 'selected' : '' }}>En Cours d'Examen</option>
                        <option value="approuve" {{ request('statut') == 'approuve' ? 'selected' : '' }}>Approuvé</option>
                        <option value="rejete" {{ request('statut') == 'rejete' ? 'selected' : '' }}>Rejeté</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <select name="region" class="form-select">
                        <option value="">Toutes les régions</option>
                        @foreach($regions as $region)
                            <option value="{{ $region }}" {{ request('region') == $region ? 'selected' : '' }}>{{ $region }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <div class="input-group">
                        <input type="text" name="search" class="form-control" placeholder="Rechercher..." value="{{ request('search') }}">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-search"></i> Filtrer
                        </button>
                        <a href="{{ route('financements.index') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-counterclockwise"></i> Annuler
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Liste des Demandes -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Référence</th>
                            <th>Structure</th>
                            <th>Activité</th>
                            <th>Région</th>
                            <th>Montant Demandé</th>
                            <th>Date Soumission</th>
                            <th>Statut</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($financements as $financement)
                        <tr>
                            <td>
                                <strong>{{ $financement->reference }}</strong>
                            </td>
                            <td>
                                <div>{{ $financement->nom_structure }}</div>
                                <small class="text-muted">{{ $financement->statut_juridique }}</small>
                            </td>
                            <td>{{ Str::limit($financement->intitule_activite, 30) }}</td>
                            <td>{{ $financement->region }}</td>
                            <td>{{ number_format($financement->montant_sollicite, 0, ',', ' ') }} FCFA</td>
                            <td>{{ $financement->created_at->format('d/m/Y') }}</td>
                            <td>
                                @php
                                    $statusColors = [
                                        'en_attente' => 'warning',
                                        'en_cours' => 'info',
                                        'approuve' => 'success',
                                        'rejete' => 'danger',
                                        'complet' => 'primary',
                                        'incomplet' => 'secondary'
                                    ];
                                    $statusLabels = [
                                        'en_attente' => 'En Attente',
                                        'en_cours' => 'En Cours',
                                        'approuve' => 'Approuvé',
                                        'rejete' => 'Rejeté',
                                        'complet' => 'Dossier Complet',
                                        'incomplet' => 'Dossier Incomplet'
                                    ];
                                @endphp
                                <span class="badge bg-{{ $statusColors[$financement->statut] ?? 'secondary' }}">
                                    {{ $statusLabels[$financement->statut] ?? $financement->statut }}
                                </span>
                            </td>
                            <td>
                                <a href="{{ route('financements.show', $financement) }}" class="btn btn-sm btn-outline-primary" title="Voir les détails">
                                    <i class="bi bi-eye"></i>
                                </a>
                                {{-- @can('update', $financement) --}}
                                <a href="{{ route('financements.edit', $financement) }}" class="btn btn-sm btn-outline-secondary" title="Modifier">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                {{-- @endcan --}}
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center">Aucune demande de financement trouvée</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $financements->links() }}
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Script pour confirmer la suppression
    function confirmDelete(id) {
        if (confirm('Êtes-vous sûr de vouloir supprimer cette demande de financement ?')) {
            document.getElementById('delete-form-' + id).submit();
        }
    }
</script>
@endpush

@endsection
