@extends('layouts.front')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-header bg-primary ">
                    <h4 class="mb-0 text-white">Suivi de votre demande de financement</h4>
                </div>
                <div class="card-body">

                    <div class="complaint-details">
                        <h5 class="text-primary mb-4">Détails de la demande</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 40%;">Reference de la demande</th>
                                    <td>{{ $financement->reference }}</td>
                                </tr>
                                <tr>
                                    <th>Date de dépôt</th>
                                    <td>{{ $financement->created_at->format('d/m/Y à H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>Structure</th>
                                    <td>{{ $financement->nom_structure }}</td>
                                </tr>
                                <tr>
                                    <th>Intitule de l'activite</th>
                                    <td>{{ $financement->intitule_activite }}</td>
                                </tr>
                                <tr>
                                    <th>Statut</th>
                                    <td>
                                        @php
                                            $statusClass = [
                                                'en_attente' => 'badge bg-primary',
                                                'en_cours' => 'badge bg-info',
                                                'approuve' => 'badge bg-success',
                                                'rejete' => 'badge bg-danger',
                                                'archive' => 'badge bg-warning',
                                            ][$financement->statut] ?? 'badge bg-secondary';
                                            
                                            $statusText = [
                                                'en_attente' => 'En attente de traitement',
                                                'en_cours' => 'En cours de traitement',
                                                'approuve' => 'Approuvé',
                                                'rejete' => 'Rejeté',
                                                'archive' => 'Clos',
                                            ][$financement->statut] ?? $financement->statut;
                                        @endphp
                                        <span class="{{ $statusClass }}">{{ $statusText }}</span>
                                    </td>
                                </tr>
                                
                            </table>
                            @if($financement->statut === 'rejete')
                            <div class="alert alert-danger">
                                <strong>Date : </strong> {{ $financement->updated_at->format('d/m/Y à H:i') }}
                                <p>{{ $financement->commentaire }}</p>
                            </div>
                            @endif
                            @if($financement->statut === 'approuve')
                            <div class="alert alert-success">
                                <strong>Date : </strong> {{ $financement->updated_at->format('d/m/Y à H:i') }}
                                <p> Votre demande de financement a été approuvee. Veuillez consulter votre email pour plus de details.</p>
                            </div>
                            @endif
                        </div>
                    </div>


                    <div class="mt-4">
                        <a href="{{ route('home') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Retour à l'accueil
                        </a>
                        <a href="mailto:{{ config('mail.from.address') }}?subject=Question concernant la demande de financement {{ $financement->reference }}" 
                            class="btn btn-primary float-end">
                            <i class="fas fa-envelope me-2"></i>Nous contacter
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
@if(session('success'))
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'success',
                title: 'Succès !',
                text: '{{ session('success') }}',
                confirmButtonColor: '#018d37',
                confirmButtonText: 'OK'
            });
        });
    </script>
@endif
@endpush

@if(session('error'))
    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'error',
                title: 'Erreur',
                text: '{{ session('error') }}',
                confirmButtonColor: '#dc3545',
                confirmButtonText: 'OK'
            });
        });
    </script>
    @endpush
@endif
@push('styles')
<style>
    .timeline {
        position: relative;
        padding-left: 2rem;
    }
    
    .timeline::before {
        content: '';
        position: absolute;
        left: 0.5rem;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e9ecef;
    }
    
    .timeline-step {
        position: relative;
        padding-bottom: 1.5rem;
        padding-left: 2rem;
    }
    
    .timeline-step:last-child {
        padding-bottom: 0;
    }
    
    .timeline-step::before {
        content: '';
        position: absolute;
        left: -1.5rem;
        top: 0.25rem;
        width: 1rem;
        height: 1rem;
        border-radius: 50%;
        background: #0d6efd;
        border: 2px solid #fff;
        z-index: 1;
    }
    
    .timeline-content {
        background: #f8f9fa;
        padding: 1rem;
        border-radius: 0.5rem;
        border: 1px solid #e9ecef;
    }
    
    .complaint-details th {
        background-color: #f8f9fa;
    }
</style>
@endpush
