<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/vendors/bootstrap-icons/bootstrap-icons.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/pages/auth.css') }}">
</head>
<style>


</style>
<body class="vh-100">

        <div id="auth" class="d-flex justify-content-center align-items-center">

            <div class="">
                @if (session('error'))
                        <div class="text-red-600 font-medium text-sm mb-4 text-start">
                            {{ session('error') }}
                        </div>
                @endif
                <div id="auth-sign-in">
                    <div class="auth-logo">
                        <a href="{{ route('home') }}"><img src="{{ asset('assets/images/fie.jpg') }}" alt="Logo"></a>
                    </div>
                    <h1 class="auth-title">@lang('auth.login.title')</h1>

                    <p class="auth-subtitle mb-1">@lang('auth.login.subtitle')</p>

                    <form action="{{ route('login.post') }}" method="POST">
                        @csrf
                        <div class="form-group position-relative has-icon-left mb-4">
                            <input type="text" class="form-control form-control-lg @error('email') is-invalid @enderror"  placeholder="@lang('auth.login.email')" name="email" value="{{ old('email') }}" required>
                            <div class="form-control-icon">
                                <i class="bi bi-person"></i>
                            </div>
                            @error('email')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group position-relative has-icon-left mb-4">
                            <input type="password" class="form-control form-control-lg @error('password') is-invalid @enderror" placeholder="@lang('auth.login.password')" name="password" value="{{ old('password') }}" required>
                            <div class="form-control-icon">
                                <i class="bi bi-shield-lock"></i>
                            </div>
                            {{-- Bootstrap error message --}}
                            @error('password')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-check form-check-lg d-flex align-items-end">
                            <input type="hidden" name="remember" value="0" id="">
                            <input class="form-check-input me-2" type="checkbox" value="1" id="flexCheckDefault" {{ old('remember') ? 'checked' : '' }} name="remember">
                            <label class="form-check-label text-gray-600" for="flexCheckDefault">
                                @lang('auth.login.remember_me')
                            </label>
                        </div>
                        <button type="submit" class="btn btn-primary btn-block btn-lg shadow-lg mt-3">@lang('auth.login.login_button')</button>
                    </form>
</body>

</html>