@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h2>Gestion des Plaintes 
                <a href="{{ route('plaintes.create') }}" class="btn btn-success btn-sm float-end">
                    <i class="fas fa-plus me-2"></i> Nouvelle Plainte
                </a>
            </h2>
        </div>
    </div>

    <!-- Statistiques Dashboard -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5 class="text-white">{{ $stats['total'] }}</h5>
                    <p>Total Plaintes</p>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <h5 class="text-white">{{ $stats['en_attente'] }}</h5>
                    <p>En Attente</p>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5 class="text-white">{{ $stats['resolues'] }}</h5>
                    <p>Résolues</p>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5 class="text-white">{{ $stats['sensibles'] }}</h5>
                    <p>Sensibles</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark text-white">
                <div class="card-body">
                    <h5 class="text-white">{{ $stats['delai_depasse'] }}</h5>
                    <p>Délai Dépassé</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtres -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="py-2">
                <div class="float-center">
                    <a href="{{ route('exports.plaintes.excel') }}" class="btn btn-success">
                        <i class="bi bi-file-excel me-2"></i> Exporter en Excel
                    </a>
                    <a href="{{ route('exports.plaintes.pdf') }}" class="btn btn-danger">
                        <i class="bi bi-file-pdf me-2"></i> Exporter en PDF
                    </a>
                </div>
                <div class="clearfix"></div>
            </div>
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <select name="statut" class="form-select">
                        <option value="">Tous les statuts</option>
                        <option value="recu" {{ request('statut') == 'recu' ? 'selected' : '' }}>Reçu</option>
                        <option value="en_examen" {{ request('statut') == 'en_examen' ? 'selected' : '' }}>En Examen</option>
                        <option value="recevable" {{ request('statut') == 'recevable' ? 'selected' : '' }}>Recevable</option>
                        <option value="irrecevable" {{ request('statut') == 'irrecevable' ? 'selected' : '' }}>Irrecevable</option>
                        <option value="en_enquete" {{ request('statut') == 'en_enquete' ? 'selected' : '' }}>En Enquête</option>
                        <option value="resolu" {{ request('statut') == 'resolu' ? 'selected' : '' }}>Résolu</option>
                        <option value="clos" {{ request('statut') == 'clos' ? 'selected' : '' }}>Clos</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="niveau_sensibilite" class="form-select">
                        <option value="">Toutes sensibilités</option>
                        <option value="sensible" {{ request('niveau_sensibilite') == 'sensible' ? 'selected' : '' }}>Sensible</option>
                        <option value="non_sensible" {{ request('niveau_sensibilite') == 'non_sensible' ? 'selected' : '' }}>Non Sensible</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="Rechercher..." value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary"> <i class="bi bi-search"></i> Filtrer</button>
                    <a href="{{ route('plaintes.index') }}" class="btn btn-outline-secondary"> <i class="bi bi-arrow-counterclockwise"></i> Annuler</a>
                </div>
            </form>
        </div>
    </div>

    <!-- Liste des Plaintes -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Numéro</th>
                            <th>Plaignant</th>
                            <th>Objet</th>
                            <th>Type</th>
                            <th>Sensibilité</th>
                            <th>Statut</th>
                            <th>Date Réception</th>
                            <th>Délai</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($plaintes as $plainte)
                        <tr class="{{ $plainte->isDelaiDepasse() ? 'table-warning' : '' }}">
                            <td>
                                <strong>{{ $plainte->numero }}</strong>
                                @if($plainte->est_lanceur_alerte)
                                    <span class="badge bg-info">Lanceur d'alerte</span>
                                @endif
                            </td>
                            <td>
                                @if($plainte->est_anonyme)
                                    <em>Anonyme</em>
                                @else
                                    {{ $plainte->plaignant?->full_name }}
                                @endif
                            </td>
                            <td>{{ Str::limit($plainte->objet, 50) }}</td>
                            <td><span class="badge bg-secondary">{{ ucfirst($plainte->type_plainte) }}</span></td>
                            <td>
                                <span class="badge {{ $plainte->niveau_sensibilite == 'sensible' ? 'bg-danger' : 'bg-success' }}">
                                    {{ ucfirst($plainte->niveau_sensibilite) }}
                                </span>
                            </td>
                            <td>
                                @php
                                    $statusColors = [
                                        'recu' => 'info',
                                        'en_examen' => 'warning',
                                        'recevable' => 'primary',
                                        'irrecevable' => 'danger',
                                        'en_enquete' => 'info',
                                        'resolu' => 'success',
                                        'clos' => 'dark'
                                    ];
                                @endphp
                                <span class="badge bg-{{ $statusColors[$plainte->statut] ?? 'secondary' }}">
                                    {{ ucfirst(str_replace('_', ' ', $plainte->statut)) }}
                                </span>
                            </td>
                            <td>{{ $plainte->date_reception->format('d/m/Y H:i') }}</td>
                            <td>
                                <span class="{{ $plainte->isDelaiDepasse() ? 'text-danger fw-bold' : '' }}">
                                    {{ $plainte->delai_traitement_humans }}
                                </span>
                            </td>
                            <td>
                                <a href="{{ route('plaintes.show', $plainte) }}" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center">Aucune plainte trouvée</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            {{ $plaintes->links() }}
        </div>
    </div>
</div>
@endsection


