@extends('layouts.app')

@push('styles')
<style>
    /* .label { font-weight: 600; color: #6c757d; }
    .value { color: #212529; } */
</style>
@endpush

@section('content')
<div class="container-fluid">
    
    <div class="row mb-3">
        <div class="col-12 d-flex align-items-center justify-content-between">
            <h2 class="mb-0">Détails de la Plainte</h2>
            <div>
               
                <a href="{{ route('plaintes.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Retour
                </a>
            </div>
        </div>
    </div>
    
    <div class="col-lg-12">
        <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center">
                <div>
                    <strong>Actions</strong> 
                </div>
                <small class="text-muted">Délai de traitement: 
                        <span class="{{ $plainte->isDelaiDepasse() ? 'text-danger fw-bold' : '' }}">{{  $plainte->delai_traitement_humans }}</span>
                    </small>
            </div>
            <div class="card-body">
                <div class="row">
                    @if(in_array($plainte->statut, ['recu', 'en_examen']) && empty($plainte->resolution_proposee))
                        <div class="col-4">
                        <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#proposerResolutionModal">
                            <i class="fas fa-lightbulb me-1"></i> Proposer une résolution
                        </button>
                        </div>
                    @endif
                    @if($plainte->statut=='recu')
                    <div class="col-4">
                    <form action="{{ route('plaintes.update-status', $plainte) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <input type="hidden" name="statut" value="en_examen">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check me-1"></i> Marquer comme examinée
                        </button>
                    </form>
                    </div>
                        @endif
                    @if($plainte->statut=='en_attente')
                    <div class="col-4">
                    <form action="{{ route('plaintes.update-status', $plainte) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <input type="hidden" name="statut" value="recevable">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check me-1"></i> Marquer comme recevable
                        </button>
                    </form>
                    </div>
                    @endif
                    @if($plainte->statut=='recevable')
                    <div class="col-4">
                    <form action="{{ route('plaintes.update-status', $plainte) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <input type="hidden" name="statut" value="irrecevable">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check me-1"></i> Marquer comme irrecevable
                        </button>
                    </form>
                    </div>
                    @endif
                    @if($plainte->statut=='recevable')
                    <div class="col-4">
                    <form action="{{ route('plaintes.update-status', $plainte) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <input type="hidden" name="statut" value="en_enquete">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check me-1"></i> Marquer comme en enquête
                        </button>
                    </form>
                    </div>
                    @endif
                    @if($plainte->statut=='resolu')
                    <div class="col-4">
                    <form action="{{ route('plaintes.update-status', $plainte) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <input type="hidden" name="statut" value="clos">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check me-1"></i> Marquer comme clos
                        </button>
                    </form>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="row g-3">
        <!-- Carte: Informations Plainte -->
        <div class="col-lg-8">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <strong>Plainte N°</strong> <span class="badge bg-primary">{{ $plainte->numero }}</span>
                    </div>
                    <div>
                        @php
                            $statusColors = [
                                'recu' => 'info',
                                'en_examen' => 'warning',
                                'recevable' => 'primary',
                                'irrecevable' => 'danger',
                                'en_enquete' => 'info',
                                'resolu' => 'success',
                                'clos' => 'dark'
                            ];
                        @endphp
                        <span class="badge bg-{{ $statusColors[$plainte->statut] ?? 'secondary' }}">
                            {{ ucfirst(str_replace('_', ' ', $plainte->statut)) }}
                        </span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="label">Objet</div>
                        <div class="value">{{ $plainte->objet }}</div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <div class="label">Type</div>
                            <div>
                                <span class="badge bg-secondary">{{ ucfirst($plainte->type_plainte) }}</span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="label">Sensibilité</div>
                            <div>
                                <span class="badge {{ $plainte->niveau_sensibilite == 'sensible' ? 'bg-danger' : 'bg-success' }}">
                                    {{ ucfirst($plainte->niveau_sensibilite) }}
                                </span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="label">Date de réception</div>
                            <div class="value">{{ optional($plainte->date_reception)->format('d/m/Y H:i') }}</div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="label">Description</div>
                        <div class="value">{!! nl2br(e($plainte->description)) !!}</div>
                    </div>

                    @if(!empty($plainte->media))
                        <div class="mb-3">
                            <div class="label">Pièces justificatives</div>
                            <ul class="list-group">
                                @foreach($plainte->media as $f)
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div class="me-3">
                                            <i class="fas fa-paperclip me-2"></i>{{ $f['nom'] ?? basename($f['chemin'] ?? '') }}
                                            {{-- @if(!empty($f['type']))
                                                <span class="badge bg-light text-dark ms-2">{{ $f['type'] }}</span>
                                            @endif --}}
                                            @if(!empty($f['taille']))
                                                <small class="text-muted ms-2">{{ number_format(($f['taille']/1024), 0) }} KB</small>
                                            @endif
                                        </div>
                                        @if(!empty($f['chemin']))
                                            <a class="btn btn-sm btn-outline-primary" target="_blank" href="{{ asset('storage/' . $f['chemin']) }}">
                                                Ouvrir
                                            </a>
                                        @endif
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Carte: Informations Plaignant -->
        <div class="col-lg-4">
            <div class="card h-100">
                <div class="card-header">
                    <strong>Plaignant</strong>
                    @if($plainte->est_lanceur_alerte)
                        <span class="badge bg-info ms-2">Lanceur d'alerte</span>
                    @endif
                </div>
                <div class="card-body">
                    @if($plainte->est_anonyme)
                        <p class="mb-0"><em>Plainte anonyme</em></p>
                    @else
                        <div class="mb-2">
                            <div class="label">Nom complet</div>
                            <div class="value">{{ $plainte->plaignant->full_name ?? ($plainte->plaignant->nom ?? '') }}</div>
                        </div>
                        <div class="mb-2">
                            <div class="label">Téléphone</div>
                            <div class="value">{{ $plainte->plaignant->telephone ?? '—' }}</div>
                        </div>
                        <div class="mb-2">
                            <div class="label">Email</div>
                            <div class="value">{{ $plainte->plaignant->email ?? '—' }}</div>
                        </div>
                        <div class="mb-2">
                            <div class="label">Type</div>
                            <div class="value text-capitalize">{{ $plainte->plaignant->type ?? '—' }}</div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Historique des activités -->
    <div class="row g-3 mt-1">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <strong>Historique des activités</strong>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="">
                                <tr>
                                    <th>Date</th>
                                    <th>Utilisateur</th>
                                    <th>Action</th>
                                    <th>Détails</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $activities = $plainte->activities()->latest()->get();
                                @endphp
                                @forelse($activities as $activity)
                                    <tr>
                                        <td>{{ $activity->created_at->format('d/m/Y H:i') }}</td>
                                        <td>
                                            {{ $activity->causer->fullname ?? 'Système' }}
                                        </td>
                                        <td>
                                            @php
                                                $eventMap = [
                                                    'created' => 'Création',
                                                    'updated' => 'Mise à jour',
                                                    'deleted' => 'Suppression'
                                                ];
                                                $event = strtolower(class_basename($activity->event));
                                                echo $eventMap[$event] ?? $activity->event;
                                            @endphp
                                        </td>
                                        <td>
                                            @if($activity->properties->has('attributes'))
                                                @php
                                                    $changes = [];
                                                    $old = $activity->properties->get('old', []);
                                                    $new = $activity->properties->get('attributes', []);
                                                    
                                                    $labels = [
                                                        'statut' => 'Statut',
                                                        'decision' => 'Décision',
                                                        'assigned_to' => 'Assignation'
                                                    ];
                                                    
                                                    foreach ($new as $key => $value) {
                                                        if (in_array($key, ['statut', 'decision', 'assigned_to'])) {
                                                            $oldValue = $old[$key] ?? null;
                                                            if ($key === 'statut') {
                                                                $statusMap = [
                                                                    'recu' => 'Reçu',
                                                                    'en_examen' => 'En examen',
                                                                    'recevable' => 'Recevable',
                                                                    'irrecevable' => 'Irrecevable',
                                                                    'en_enquete' => 'Enquête',
                                                                    'resolu' => 'Résolu',
                                                                    'clos' => 'Clos'
                                                                ];
                                                                $oldValue = $statusMap[$oldValue] ?? $oldValue;
                                                                $value = $statusMap[$value] ?? $value;
                                                            } elseif ($key === 'assigned_to' && $value) {
                                                                $user = \App\Models\User::find($value);
                                                                $value = $user ? $user->name : $value;
                                                                if ($oldValue) {
                                                                    $oldUser = \App\Models\User::find($oldValue);
                                                                    $oldValue = $oldUser ? $oldUser->name : $oldValue;
                                                                }
                                                            }
                                                            $changes[] = "<strong>{$labels[$key]}</strong>: " . 
                                                                       ($oldValue ? "$oldValue → " : '') . $value;
                                                        }
                                                    }
                                                    echo implode('<br>', $changes);
                                                @endphp
                                            @else
                                                {{ $activity->description }}
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center text-muted py-3">Aucune activité enregistrée</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('resolutions.table', ['resolutions' => $plainte->resolutions])
</div>
{{-- Resolution Proposal Modal --}}
<div class="modal fade" id="proposerResolutionModal" tabindex="-1" aria-labelledby="proposerResolutionModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form action="{{ route('plaintes.proposer-resolution', $plainte) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-header bg-primary">
                    <h5 class="modal-title" id="proposerResolutionModalLabel">
                        <i class="bi bi-lightbulb me-2 text-white"></i>Proposer une résolution
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-4">
                        <label for="resolution" class="form-label">Description de la résolution proposée <span class="text-danger">*</span></label>
                        <textarea name="resolution" id="resolution" class="form-control" rows="5" required
                            placeholder="Décrivez en détail la résolution que vous proposez...">{{ old('resolution') }}</textarea>
                        @error('resolution')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="fichiers" class="form-label">Pièces jointes (optionnel)</label>
                        <input type="file" class="form-control" id="fichiers" name="fichiers[]" multiple>
                        <div class="form-text">Vous pouvez sélectionner plusieurs fichiers (PDF, images, documents)</div>
                        @error('fichiers.*')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Cette proposition sera envoyée au plaignant pour acceptation ou refus.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i> Annuler
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-paper-plane me-1"></i> Envoyer la proposition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('styles')
<style>
    /* Modal styling */
    #proposerResolutionModal .modal-content {
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }
    
    #proposerResolutionModal .modal-header {
        border-radius: 0.5rem 0.5rem 0 0;
        padding: 1.25rem 1.5rem;
    }
    
    #proposerResolutionModal .modal-body {
        padding: 1.5rem;
    }
    
    #proposerResolutionModal .modal-footer {
        border-top: 1px solid #e9ecef;
        padding: 1rem 1.5rem;
    }
    
    /* File input styling */
    .file-input-container {
        position: relative;
        overflow: hidden;
        display: inline-block;
    }
    
    .file-input-button {
        border: 1px solid #ced4da;
        border-radius: 0.25rem;
        padding: 0.375rem 0.75rem;
        background-color: #f8f9fa;
        cursor: pointer;
    }
    
    .file-input {
        position: absolute;
        left: 0;
        top: 0;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        #proposerResolutionModal .modal-dialog {
            margin: 0.5rem;
        }
    }
</style>
@endpush
@push('scripts')
<script>
    // Initialize any file input plugins if needed
    document.addEventListener('DOMContentLoaded', function() {
        // File input styling
        const fileInput = document.getElementById('fichiers');
        if (fileInput) {
            fileInput.addEventListener('change', function(e) {
                const files = e.target.files;
                const fileList = document.getElementById('fileList');
                
                if (!fileList) {
                    const fileListElement = document.createElement('div');
                    fileListElement.id = 'fileList';
                    fileListElement.className = 'mt-2';
                    fileInput.parentNode.insertBefore(fileListElement, fileInput.nextSibling);
                }
                
                if (files.length > 0) {
                    let fileListHTML = '<div class="alert alert-light p-2"><strong>Fichiers sélectionnés :</strong><ul class="mb-0">';
                    for (let i = 0; i < files.length; i++) {
                        fileListHTML += `<li>${files[i].name} (${formatFileSize(files[i].size)})</li>`;
                    }
                    fileListHTML += '</ul></div>';
                    fileList.innerHTML = fileListHTML;
                } else {
                    fileList.innerHTML = '';
                }
            });
        }

        // Format file size
        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
        }

        // Handle modal form submission
        const resolutionForm = document.querySelector('#proposerResolutionModal form');
        if (resolutionForm) {
            resolutionForm.addEventListener('submit', function(e) {
                const textarea = this.querySelector('textarea[name="resolution_proposee"]');
                if (textarea.value.trim() === '') {
                    e.preventDefault();
                    textarea.classList.add('is-invalid');
                    const errorDiv = document.createElement('div');
                    errorDiv.className = 'invalid-feedback d-block';
                    errorDiv.textContent = 'Veuillez saisir une description de la résolution.';
                    textarea.parentNode.appendChild(errorDiv);
                }
            });
        }
    });
</script>
@endpush
@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto-resize textarea
        const textarea = document.querySelector('textarea[name="decision"]');
        if (textarea) {
            textarea.style.height = 'auto';
            textarea.style.height = (textarea.scrollHeight) + 'px';
            
            textarea.addEventListener('input', function() {
                this.style.height = 'auto';
                this.style.height = (this.scrollHeight) + 'px';
            });
        }
    });
</script>
@endpush

@endsection
