@extends('layouts.app')

@section('content')
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Détails de la proposition de résolution</h5>
                    <div>
                        <a href="{{ route('plaintes.show', $plainte) }}" class="btn btn-light btn-sm">
                            <i class="fas fa-arrow-left me-1"></i> Retour à la plainte
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h6 class="text-muted">Plainte concernée</h6>
                            <p class="h5">#{{ $plainte->numero }} - {{ $plainte->objet }}</p>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <h6 class="text-muted">Proposé le</h6>
                            <p class="h5">{{ $resolution->date_proposition->format('d/m/Y à H:i') }}</p>
                        </div>
                    </div>

                    <div class="card mb-4">
                        <div class="card-header bg-light">
                            <h6 class="mb-0">Description de la résolution</h6>
                        </div>
                        <div class="card-body">
                            {!! nl2br(e($resolution->resolution)) !!}
                        </div>
                    </div>

                    @if($resolution->media->count() > 0)
                        <div class="card mb-4">
                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Pièces jointes</h6>
                                <span class="badge bg-primary">{{ $resolution->media->count() }}</span>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    @foreach($resolution->media as $media)
                                        <div class="col-md-6 col-lg-4">
                                            <div class="card h-100">
                                                <div class="card-body text-center">
                                                    @if(in_array($media->mime_type, ['image/jpeg', 'image/png', 'image/gif']))
                                                        <img src="{{ Storage::disk('public')->url($media->file_path) }}" 
                                                             class="img-fluid mb-2" style="max-height: 150px;" 
                                                             alt="{{ $media->file_name }}">
                                                    @else
                                                        <i class="fas fa-file-alt fa-4x text-muted mb-2"></i>
                                                    @endif
                                                    <p class="mb-1 text-truncate" title="{{ $media->file_name }}">
                                                        {{ $media->file_name }}
                                                    </p>
                                                    <a href="{{ Storage::disk('public')->url($media->file_path) }}" 
                                                       class="btn btn-sm btn-outline-primary" target="_blank" download>
                                                        <i class="fas fa-download me-1"></i> Télécharger
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($resolution->statut !== 'en_attente')
                        <div class="card mb-4 border-{{ $resolution->statut === 'acceptee' ? 'success' : 'danger' }}">
                            <div class="card-header bg-{{ $resolution->statut === 'acceptee' ? 'success' : 'danger' }} text-white">
                                <h6 class="mb-0">Décision</h6>
                            </div>
                            <div class="card-body">
                                <p class="mb-2">
                                    <strong>Statut :</strong> 
                                    <span class="badge bg-{{ $resolution->statut === 'acceptee' ? 'success' : 'danger' }}">
                                        {{ $resolution->statut === 'acceptee' ? 'Acceptée' : 'Refusée' }}
                                    </span>
                                </p>
                                @if($resolution->date_validation)
                                    <p class="mb-2">
                                        <strong>Date de décision :</strong> 
                                        {{ $resolution->date_validation->format('d/m/Y à H:i') }}
                                    </p>
                                @endif
                                @if($resolution->commentaire)
                                    <div class="mt-3">
                                        <h6>Commentaire :</h6>
                                        <div class="p-3 bg-light rounded">
                                            {!! nl2br(e($resolution->commentaire)) !!}
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif

                    <div class="d-flex justify-content-between mt-4">
                        <div>
                            @can('update', $resolution)
                                <a href="{{ route('plaintes.resolutions.edit', [$plainte, $resolution]) }}" 
                                   class="btn btn-outline-secondary me-2">
                                    <i class="fas fa-edit me-1"></i> Modifier
                                </a>
                            @endcan
                            
                            @can('delete', $resolution)
                                <form action="{{ route('plaintes.resolutions.destroy', [$plainte, $resolution]) }}" 
                                      method="POST" class="d-inline" 
                                      onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cette proposition ?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline-danger">
                                        <i class="fas fa-trash me-1"></i> Supprimer
                                    </button>
                                </form>
                            @endcan
                        </div>

                        @if($resolution->statut === 'en_attente' && auth()->id() === $plainte->plaignant_id)
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#acceptResolutionModal">
                                    <i class="fas fa-check me-1"></i> Accepter
                                </button>
                                <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectResolutionModal">
                                    <i class="fas fa-times me-1"></i> Refuser
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Accept Resolution Modal -->
<div class="modal fade" id="acceptResolutionModal" tabindex="-1" aria-labelledby="acceptResolutionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('resolutions.accept', $resolution) }}" method="POST">
                @csrf
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="acceptResolutionModalLabel">Accepter la résolution</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Êtes-vous sûr de vouloir accepter cette proposition de résolution ?</p>
                    <div class="mb-3">
                        <label for="commentaire" class="form-label">Commentaire (optionnel) :</label>
                        <textarea name="commentaire" id="commentaire" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-success">Confirmer l'acceptation</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Reject Resolution Modal -->
<div class="modal fade" id="rejectResolutionModal" tabindex="-1" aria-labelledby="rejectResolutionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('resolutions.reject', $resolution) }}" method="POST">
                @csrf
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="rejectResolutionModalLabel">Refuser la résolution</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Veuillez indiquer la raison de votre refus :</p>
                    <div class="mb-3">
                        <label for="commentaire" class="form-label">Raison du refus <span class="text-danger">*</span></label>
                        <textarea name="commentaire" id="commentaire" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-danger">Confirmer le refus</button>
                </div>
            </form>
        </div>
    </div>
</div>