
<div class="card shadow-sm">
    <div class="card-header text-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Propositions de résolution </h5>
        
    </div>

    <div class="card-body">

        @if($resolutions->isEmpty())
            <div class="text-center py-5">
                <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
                <p class="h5 text-muted">Aucune proposition de résolution trouvée</p>
                {{-- @can('create', [App\Models\Resolution::class, $plainte]) --}}
                    {{-- <a href="{{ route('plaintes.resolutions.create', $plainte) }}" class="btn btn-primary mt-3">
                        <i class="fas fa-plus me-1"></i> Proposer une résolution
                    </a> --}}
                    <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#proposerResolutionModal">
                        <i class="fas fa-lightbulb me-1"></i> Proposer une résolution
                    </button>
                {{-- @endcan --}}
            </div>
        @else
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Date de proposition</th>
                            <th>Statut</th>
                            <th>Proposé par</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($resolutions as $resolution)
                            <tr>
                                <td>{{ $resolution->date_proposition->format('d/m/Y H:i') }}</td>
                                <td>
                                    @php
                                        $statusClasses = [
                                            'en_attente' => 'warning',
                                            'acceptee' => 'success',
                                            'refusee' => 'danger'
                                        ];
                                    @endphp
                                    <span class="badge bg-{{ $statusClasses[$resolution->statut] ?? 'secondary' }}">
                                        {{ ucfirst($resolution->statut) }}
                                    </span>
                                </td>
                                <td>{{ $resolution->proposer->full_name ?? 'Utilisateur supprimé' }}</td>
                                <td class="text-end">
                                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#voirResolutionModal{{ $resolution->id }}"> 
                                        <i class="fas fa-eye"></i> Voir
                                    </button>
                                    
                                    @can('update')
                                        <button type="button" class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#editResolutionModal{{ $resolution->id }}">
                                            <i class="fas fa-edit"></i> Modifier
                                        </button>
                                    @endcan
                                </td>
                                {{-- modal voir --}}
                                <div class="modal fade" id="voirResolutionModal{{ $resolution->id }}" tabindex="-1" aria-labelledby="voirResolutionModalLabel{{ $resolution->id }}" aria-hidden="true">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="voirResolutionModalLabel{{ $resolution->id }}">Voir la proposition de résolution</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p><strong>Proposition:</strong></p>
                                                <p class="mb-2 rounded bg-muted">{{ $resolution->resolution }}</p>
                                                <p><strong>Statut:</strong> <span    class="badge float-end bg-{{ $resolution->statut == 'acceptee' ? 'success' : 'danger' }}">{{ $resolution->statut }}</span></p>
                                                <p><strong>Proposé par:</strong> <span class="badge bg-secondary float-end">{{ $resolution->proposer->full_name ?? 'Utilisateur supprimé' }}</span></p>
                                                <p><strong>Date de proposition:</strong> <span class="badge bg-secondary float-end">{{ $resolution->date_proposition->format('d/m/Y H:i') }}</span></p>
                                                
                                                @if(!empty($resolution->media))
                                                    <p><strong>Pièces jointes:</strong></p>
                                                    <ul>
                                                        @foreach($resolution->media as $media)
                                                            <li>{{ $media->nom }} <a class="btn btn-primary float-end btn-sm mt-2" href="{{ asset('storage/' . $media->chemin) }}" target="_blank"><i class="bi bi-eye"></i></a></li>
                                                        @endforeach
                                                    </ul>
                                                @endif 
                                                
                                            </div>

                                            
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fermer</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-4">
                <div>
                    {{-- @can('create', [App\Models\Resolution::class, $plainte])
                        <a href="{{ route('plaintes.resolutions.create', $plainte) }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Nouvelle proposition
                        </a>
                    @endcan --}}
                </div>
            </div>
        @endif
    </div>
</div>
