<?php $__env->startPush('styles'); ?>
    <style>
        /* Success Modal */
        .success-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.8);
            z-index: 9999;
            align-items: center;
            justify-content: center;
        }

        .success-modal.show {
            display: flex;
        }

        .success-content {
            background: white;
            padding: 3rem;
            border-radius: 20px;
            text-align: center;
            max-width: 500px;
            animation: slideUp 0.4s ease;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .success-icon {
            font-size: 5rem;
            color: #2e8b57;
            margin-bottom: 1rem;
        }

        .success-content h2 {
            color: #2e8b57;
            margin-bottom: 1rem;
        }

        .reference-number {
            background: #f8f9fa;
            padding: 1rem;
            border-radius: 10px;
            margin: 1rem 0;
            font-weight: bold;
            color: #2e8b57;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('hero'); ?>
<section class="hero" id="accueil">
  <div class="floating-elements"></div>
  <div class="container">
      <h1><?php echo app('translator')->get('messages.complaints_suggestions'); ?></h1>
      <p><?php echo app('translator')->get('messages.welcome_description'); ?></p>
      <div class="cta-buttons">
          <a href="<?php echo e(route('plaintes.formulaire')); ?>" class="cta-btn btn-primary">
              <i class="fas fa-paper-plane"></i>
              <?php echo app('translator')->get('messages.file_complaint'); ?>
          </a>
          <a href="#processus" class="cta-btn btn-secondary">
              <i class="fas fa-info-circle"></i>
              <?php echo app('translator')->get('messages.how_it_works'); ?>
          </a>
      </div>

  </div>
  <div class="scroll-indicator">
      <i class="fas fa-chevron-down"></i>
  </div>

</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
        <section class="content-section" id="processus">
            <div class="container">
                <div class="section-header">
                    <h2><?php echo app('translator')->get('messages.our_process'); ?></h2>
                    <p><?php echo app('translator')->get('messages.process_description'); ?></p>
                </div>

                <div class="timeline">
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-clipboard"></i> <?php echo app('translator')->get('messages.step1_title'); ?></h3>
                            <p><?php echo app('translator')->get('messages.step1_desc'); ?></p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-sort-amount-up"></i> <?php echo app('translator')->get('messages.step2_title'); ?></h3>
                            <p><?php echo app('translator')->get('messages.step2_desc'); ?></p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-check-circle"></i> <?php echo app('translator')->get('messages.step3_title'); ?></h3>
                            <p><?php echo app('translator')->get('messages.step3_desc'); ?></p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-comments"></i> <?php echo app('translator')->get('messages.step4_title'); ?></h3>
                            <p><?php echo app('translator')->get('messages.step4_desc'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="content-section">
            <div class="container">
                <div class="section-header">
                    <h2><?php echo app('translator')->get('messages.fundamental_principles'); ?></h2>
                    <p><?php echo app('translator')->get('messages.principles_description'); ?></p>
                </div>

                <div class="principles-grid">
                    <div class="principle-item">
                        <h4><i class="fas fa-eye"></i> <?php echo app('translator')->get('messages.transparency_title'); ?></h4>
                        <p><?php echo app('translator')->get('messages.transparency_desc'); ?></p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-universal-access"></i> <?php echo app('translator')->get('messages.accessibility_title'); ?></h4>
                        <p><?php echo app('translator')->get('messages.accessibility_desc'); ?></p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-balance-scale"></i> <?php echo app('translator')->get('messages.proportionality_title'); ?></h4>
                        <p><?php echo app('translator')->get('messages.proportionality_desc'); ?></p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-clock"></i> <?php echo app('translator')->get('messages.quick_resolution_title'); ?></h4>
                        <p><?php echo app('translator')->get('messages.quick_resolution_desc'); ?></p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-book"></i> <?php echo app('translator')->get('messages.recording_title'); ?></h4>
                        <p><?php echo app('translator')->get('messages.recording_desc'); ?></p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-map-marked-alt"></i> <?php echo app('translator')->get('messages.site_visits_title'); ?></h4>
                        <p><?php echo app('translator')->get('messages.site_visits_desc'); ?></p>
                    </div>
                </div>
            </div>
        </section>

        <section class="content-section" id="contact">
            <div class="container">
                <div class="section-header">
                    <h2><?php echo app('translator')->get('messages.contact_methods'); ?></h2>
                    <p><?php echo app('translator')->get('messages.choose_contact_method'); ?></p>
                </div>

                <div class="contact-methods">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-user"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.in_person'); ?></h3>
                        <p><?php echo app('translator')->get('messages.in_person_desc'); ?></p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.representation'); ?></h3>
                        <p><?php echo app('translator')->get('messages.representation_desc'); ?></p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.mail'); ?></h3>
                        <p><?php echo app('translator')->get('messages.mail_desc'); ?></p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-at"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.email'); ?></h3>
                        <p><?php echo app('translator')->get('messages.email_desc'); ?></p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.phone'); ?></h3>
                        <p><?php echo app('translator')->get('messages.phone_desc'); ?></p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-globe"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.website'); ?></h3>
                        <p><?php echo app('translator')->get('messages.website_desc'); ?></p>
                    </div>
                </div>
            </div>
        </section>

        <section class="content-section">
            <div class="container">
                <div class="section-header">
                    <h2><?php echo app('translator')->get('messages.roles_responsibilities'); ?></h2>
                </div>

                <div class="process-grid">
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-users-cog"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.regional_committees_title'); ?></h3>
                        <p><?php echo app('translator')->get('messages.regional_committees_desc'); ?></p>
                    </div>
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-inbox"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.complaint_recipients_title'); ?></h3>
                        <p><?php echo app('translator')->get('messages.complaint_recipients_desc'); ?></p>
                    </div>
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.complaint_manager_title'); ?></h3>
                        <p><?php echo app('translator')->get('messages.complaint_manager_desc'); ?></p>
                    </div>
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-handshake"></i>
                        </div>
                        <h3><?php echo app('translator')->get('messages.stakeholders_title'); ?></h3>
                        <p><?php echo app('translator')->get('messages.stakeholders_desc'); ?></p>
                    </div>
                </div>
            </div>
        </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    <?php if(isset($success)): ?> 
    showSuccessModal();
    <?php else: ?>
    console.log('Not successful');
    
    <?php endif; ?>
    function showSuccessModal() {
            const referenceNumber = 'FIE-' + Date.now().toString().slice(-8);
            document.getElementById('referenceNumber').textContent = referenceNumber;
            document.getElementById('successModal').classList.add('show');
        }

        function closeSuccessModal() {
            document.getElementById('successModal').classList.remove('show');
            resetForm();
        }
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.front', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\Plainte2\plainte-fie\resources\views/welcome.blade.php ENDPATH**/ ?>