<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-header bg-primary ">
                    <h4 class="mb-0 text-white">Suivi de votre plainte</h4>
                </div>
                <div class="card-body">

                    <div class="complaint-details">
                        <h5 class="text-primary mb-4">Détails de la plainte</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 40%;">Numéro de plainte</th>
                                    <td><?php echo e($plainte->numero); ?></td>
                                </tr>
                                <tr>
                                    <th>Date de dépôt</th>
                                    <td><?php echo e($plainte->created_at->format('d/m/Y à H:i')); ?></td>
                                </tr>
                                <tr>
                                    <th>Objet</th>
                                    <td><?php echo e($plainte->objet); ?></td>
                                </tr>
                                <tr>
                                    <th>Statut actuel</th>
                                    <td>
                                        <?php
                                            $statusClass = [
                                                'recu' => 'badge bg-primary',
                                                'en_examen' => 'badge bg-info',
                                                'recevable' => 'badge bg-success',
                                                'irrecevable' => 'badge bg-danger',
                                                'en_enquete' => 'badge bg-warning',
                                                'resolu' => 'badge bg-success',
                                                'en_appel' => 'badge bg-warning',
                                                'clos' => 'badge bg-secondary',
                                            ][$plainte->statut] ?? 'badge bg-secondary';
                                            
                                            $statusText = [
                                                'recu' => 'Reçu',
                                                'en_examen' => 'En examen',
                                                'recevable' => 'Recevable',
                                                'irrecevable' => 'Irrecevable',
                                                'en_enquete' => 'Enquête en cours',
                                                'resolu' => 'Résolu',
                                                'en_appel' => 'En appel',
                                                'clos' => 'Clôturé',
                                            ][$plainte->statut] ?? $plainte->statut;
                                        ?>
                                        <span class="<?php echo e($statusClass); ?>"><?php echo e($statusText); ?></span>
                                    </td>
                                </tr>
                                <?php if($plainte->date_decision): ?>
                                <tr>
                                    <th>Date de décision</th>
                                    <td><?php echo e($plainte->date_decision->format('d/m/Y')); ?></td>
                                </tr>
                                <?php endif; ?>
                                <?php if($plainte->decision): ?>
                                <tr>
                                    <th>Décision</th>
                                    <td><?php echo e($plainte->decision); ?></td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>

                    <div class="timeline mt-5">
                        <h5 class="text-primary mb-4">Historique des statuts</h5>
                        <?php if($plainte->statut_historique && count($plainte->statut_historique) > 0): ?>
                            <div class="position-relative">
                                <?php $__currentLoopData = $plainte->statut_historique; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="timeline-step">
                                        <div class="timeline-content">
                                            <div class="d-flex justify-content-between">
                                                <h6 class="mb-1"><?php echo e($history['statut']); ?></h6>
                                                <small class="text-muted">
                                                    <?php echo e(\Carbon\Carbon::parse($history['date'])->format('d/m/Y H:i')); ?>

                                                </small>
                                            </div>
                                            <?php if(!empty($history['commentaire'])): ?>
                                                <p class="mb-2"><?php echo e($history['commentaire']); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info">
                                Aucun historique de statut disponible pour le moment.
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="mt-4">
                        <a href="<?php echo e(route('home')); ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Retour à l'accueil
                        </a>
                        
                        <?php if(!$plainte->est_anonyme && $plainte->plaignant->email): ?>
                            <a href="mailto:<?php echo e(config('mail.from.address')); ?>?subject=Question concernant la plainte <?php echo e($plainte->numero); ?>" 
                               class="btn btn-primary float-end">
                                <i class="fas fa-envelope me-2"></i>Nous contacter
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<?php if(session('success')): ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'success',
                title: 'Succès !',
                text: '<?php echo e(session('success')); ?>',
                confirmButtonColor: '#018d37',
                confirmButtonText: 'OK'
            });
        });
    </script>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php if(session('error')): ?>
    <?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'error',
                title: 'Erreur',
                text: '<?php echo e(session('error')); ?>',
                confirmButtonColor: '#dc3545',
                confirmButtonText: 'OK'
            });
        });
    </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php $__env->startPush('styles'); ?>
<style>
    .timeline {
        position: relative;
        padding-left: 2rem;
    }
    
    .timeline::before {
        content: '';
        position: absolute;
        left: 0.5rem;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e9ecef;
    }
    
    .timeline-step {
        position: relative;
        padding-bottom: 1.5rem;
        padding-left: 2rem;
    }
    
    .timeline-step:last-child {
        padding-bottom: 0;
    }
    
    .timeline-step::before {
        content: '';
        position: absolute;
        left: -1.5rem;
        top: 0.25rem;
        width: 1rem;
        height: 1rem;
        border-radius: 50%;
        background: #0d6efd;
        border: 2px solid #fff;
        z-index: 1;
    }
    
    .timeline-content {
        background: #f8f9fa;
        padding: 1rem;
        border-radius: 0.5rem;
        border: 1px solid #e9ecef;
    }
    
    .complaint-details th {
        background-color: #f8f9fa;
    }
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\plainteproj\resources\views/plaintes/suivi-plainte.blade.php ENDPATH**/ ?>