<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/form.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container py-3">
        
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="alert alert-danger">
                <?php echo e($error); ?>

            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        <!-- Form Container -->
        <div class="form-container">

            <div class="form-title">
                <i class="fas fa-file-invoice-dollar"></i> <?php echo app('translator')->get('messages.complaint_form'); ?>
            </div>
            
            
            <!-- Form Content -->
            <form id="fundingForm" action="<?php echo e(route('plaintes.store')); ?>" method="POST" enctype="multipart/form-data" class="form-content my-3 needs-validation" novalidate>
                <?php echo csrf_field(); ?>
                <input type="hidden" name="canal_reception" value="web" >
                <!-- Section 1: Informations du plaignant -->
                
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-building"></i>
                        <h3><?php echo app('translator')->get('messages.complainant_information'); ?></h3>
                    </div>
                    <div class="form-row">
                        
                        <div class="form-group">
                            <label class="form-label required"><?php echo app('translator')->get('messages.anonymous_complaint'); ?></label>
                            <select name="est_anonyme" id="est_anonyme" class="form-control" required>
                                <option <?php echo e(old('est_anonyme') == '' ? 'selected' : ''); ?> value=""><?php echo app('translator')->get('messages.select'); ?></option>
                                <option <?php echo e(old('est_anonyme') == '0' ? 'selected' : ''); ?> value="0"><?php echo app('translator')->get('messages.no'); ?></option>
                                <option <?php echo e(old('est_anonyme') == '1' ? 'selected' : ''); ?> value="1"><?php echo app('translator')->get('messages.yes'); ?></option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label required"><?php echo app('translator')->get('messages.who_are_you'); ?></label>
                            <select name="plaignant[type]" id="type_plaignant" class="form-control" required>
                                <option <?php echo e(old('plaignant.type') == '' ? 'selected' : ''); ?> value=""><?php echo app('translator')->get('messages.select'); ?></option>
                                <option <?php echo e(old('plaignant.type') == 'individu' ? 'selected' : ''); ?> value="individu"><?php echo app('translator')->get('messages.individual'); ?></option>
                                <option <?php echo e(old('plaignant.type') == 'groupe' ? 'selected' : ''); ?> value="groupe"><?php echo app('translator')->get('messages.group'); ?></option>
                                <option <?php echo e(old('plaignant.type') == 'communaute' ? 'selected' : ''); ?> value="communaute"><?php echo app('translator')->get('messages.community'); ?></option>
                            </select>
                        </div>
                        
                    </div>
                    <div id="non_anonyme" class="d-none">
                        
                        <div class="form-row individu">
                            <div class="form-group">
                                <label class="form-label required"><?php echo app('translator')->get('messages.last_name'); ?></label>
                                <input type="text" value="<?php echo e(old('plaignant.nom')); ?>" name="plaignant[nom]" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('messages.first_name'); ?></label>
                                <input type="text" value="<?php echo e(old('plaignant.prenom')); ?>" name="plaignant[prenom]" class="form-control" required>
                            </div>
                        </div>
                        <div class="form-row individu">
                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('messages.gender'); ?></label>
                                <select name="plaignant[genre]" class="form-control" required>
                                    <option <?php echo e(old('plaignant.genre') == '' ? 'selected' : ''); ?> value=""><?php echo app('translator')->get('messages.select'); ?></option>
                                    <option <?php echo e(old('plaignant.genre') == 'M' ? 'selected' : ''); ?> value="M"><?php echo app('translator')->get('messages.male'); ?></option>
                                    <option <?php echo e(old('plaignant.genre') == 'F' ? 'selected' : ''); ?> value="F"><?php echo app('translator')->get('messages.female'); ?></option>
                                </select>
                            </div>
                            <div class="form-group individu">
                                <label class="form-label required"><?php echo app('translator')->get('messages.address'); ?></label>
                                <input type="text" name="plaignant[adresse]" value="<?php echo e(old('plaignant.adresse')); ?>" class="form-control" required>
                            </div>
                        </div>
                        <div class="form-group groupe">
                                <label class="form-label"><?php echo app('translator')->get('messages.group_name'); ?></label>
                            <input type="text" name="plaignant[nom]" value="<?php echo e(old('plaignant.nom')); ?>" class="form-control" required>
                        </div>
                        <div class="form-group groupe">
                            <label class="form-label"><?php echo app('translator')->get('messages.address'); ?></label>
                            <input type="text" value="<?php echo e(old('plaignant.adresse')); ?>" name="plaignant[adresse]" class="form-control" required>
                        </div>
                        
                        <div class="form-group communaute">
                                <label class="form-label"><?php echo app('translator')->get('messages.community_name'); ?></label>
                            <input type="text" value="<?php echo e(old('plaignant.nom')); ?>" name="plaignant[nom]" class="form-control" required>
                        </div>

                        <div class="form-group communaute">
                            <label class="form-label"><?php echo app('translator')->get('messages.address'); ?></label>
                            <input type="text" value="<?php echo e(old('plaignant.adresse')); ?>" name="plaignant[adresse]" class="form-control" required>
                        </div>
                    
                        <div class="form-row">
                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('messages.phone'); ?></label>
                                <input type="tel" value="<?php echo e(old('plaignant.telephone')); ?>" name="plaignant[telephone]" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('messages.email'); ?></label>
                                <input type="email" value="<?php echo e(old('plaignant.email')); ?>" name="plaignant[email]" class="form-control" required>
                            </div>
                            
                        </div>
                    </div>
                    
                    <div class="form-group d-none" id="anonyme">
                        <label class="form-label required"><?php echo app('translator')->get('messages.email'); ?></label>
                        <input type="email" value="<?php echo e(old('plaignant.email')); ?>" name="plaignant[email]" class="form-control" required>
                        <small class="form-text text-muted"><?php echo app('translator')->get('messages.email_hint'); ?></small>
                    </div>
                </div>
                
                <!-- Section 2:  Détails de la Plainte -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-tasks"></i>
                        <h3><?php echo app('translator')->get('messages.complaint_details'); ?></h3>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label required"><?php echo app('translator')->get('messages.complaint_type'); ?></label>
                        <select name="type_plainte" class="form-control" required>
                            <option <?php echo e(old('type_plainte') == '' ? 'selected' : ''); ?> value=""><?php echo app('translator')->get('messages.select'); ?></option>
                            <option <?php echo e(old('type_plainte') == 'environnementale' ? 'selected' : ''); ?> value="environnementale"><?php echo app('translator')->get('messages.environmental'); ?></option>
                            <option <?php echo e(old('type_plainte') == 'sociale' ? 'selected' : ''); ?> value="sociale"><?php echo app('translator')->get('messages.social'); ?></option>
                            <option <?php echo e(old('type_plainte') == 'genre' ? 'selected' : ''); ?> value="genre"><?php echo app('translator')->get('messages.other'); ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label required"><?php echo app('translator')->get('messages.complaint_object'); ?></label>
                        <input type="text" name="objet" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label required"><?php echo app('translator')->get('messages.complaint_description'); ?></label>
                        <textarea name="description" class="form-control textarea" rows="5" required placeholder="<?php echo app('translator')->get('messages.describe_complaint_placeholder'); ?>"></textarea>
                    </div>
                    

                </div>
                <!-- Section 3: Pièces Jointes -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-paperclip"></i>
                        <h3><?php echo app('translator')->get('messages.supporting_documents'); ?></h3>
                    </div>

                    <div class="form-group">
                        <label class="form-label"><?php echo app('translator')->get('messages.complaint_supporting_documents'); ?></label>
                        <input type="file" id="fileInput" name="preuves[]" class="file-input" 
                               accept=".pdf,.doc,.docx,.xls,.xlsx" multiple>
                        <div class="file-upload-area" onclick="document.getElementById('fileInput').click()">
                            <i class="fas fa-cloud-upload-alt"></i>
                            <h4><?php echo app('translator')->get('messages.click_to_upload'); ?></h4>
                            <p><?php echo app('translator')->get('messages.accepted_formats'); ?>: PDF, DOC, DOCX, XLS, XLSX</p>
                            <p style="font-size: 0.9rem; color: #666;"><?php echo app('translator')->get('messages.max_file_size'); ?></p>
                        </div>
                        <div class="file-list" id="fileList"></div>
                        <div class="help-text">
                            <i class="fas fa-info-circle"></i>
                            <?php echo app('translator')->get('messages.multiple_files_info'); ?>
                        </div>
                    </div>
                </div>
                <!-- Form Actions -->
                <div class="form-actions">
                    <a href="<?php echo e(route('home')); ?>" class="btn btn-secondary" >
                        <i class="fas fa-redo"></i>
                        <?php echo app('translator')->get('messages.cancel'); ?>
                    </a>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-paper-plane"></i>
                        <?php echo app('translator')->get('messages.submit_request'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>

    

    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>

    
    $("#est_anonyme,#type_plaignant").on('change', function() {

        $("#non_anonyme input,#non_anonyme select").attr('disabled', true);
        $("#anonyme input,#anonyme select").attr('disabled', true);
        
        if ($("#est_anonyme").val() == 1) {
            $("#anonyme").removeClass('d-none');
            $("#non_anonyme").addClass('d-none');
            $("#anonyme input,#anonyme select").removeAttr('disabled');
        }
         else {
            $("#non_anonyme").removeClass('d-none');
            $("#anonyme").addClass('d-none');
            $("#non_anonyme input,#non_anonyme select").removeAttr('disabled');

            $(".groupe").addClass('d-none');
            $(".communaute").addClass('d-none');
            $(".individu").addClass('d-none');
            $(".individu input,.individu select").attr('disabled', true);
            $(".groupe input,.groupe select").attr('disabled', true);
            $(".communaute input,.communaute select").attr('disabled', true);
            var type_plaignant=$("#type_plaignant").val();
            if (type_plaignant == 'individu') {
                $(".individu").removeClass('d-none');
                $(".individu input").removeAttr('disabled');
                $(".individu select").removeAttr('disabled');
            }
            else if (type_plaignant == 'groupe') {
                $(".groupe").removeClass('d-none');
                $(".groupe input").removeAttr('disabled');
                $(".groupe select").removeAttr('disabled');
            }
            else if (type_plaignant == 'communaute') {
                $(".communaute").removeClass('d-none');
                $(".communaute input").removeAttr('disabled');
                $(".communaute select").removeAttr('disabled');
            }
        }
        
    });
</script>
   <script>
        // Progress tracking
        // const form = document.getElementById('fundingForm');
        // const progressFill = document.getElementById('progressFill');
        // const progressText = document.getElementById('progressText');

        // function updateProgress() {
        //     //Ignore required fields in hidden sections
        //     const inputs = form.querySelectorAll('input[required]:not([disabled]), textarea[required]:not([disabled]), select[required]:not([disabled])');
        //     let filled = 0;
            
        //     inputs.forEach(input => {
        //         if (input.value.trim() !== '') {
        //             filled++;
        //         }
        //     });
            
        //     const percentage = Math.round((filled / inputs.length) * 100);
        //     progressFill.style.width = percentage + '%';
        //     progressText.textContent = percentage + '% ' + '<?php echo app('translator')->get('messages.complete'); ?>';
        // }

        // Add event listeners to all form inputs
        // form.addEventListener('input', updateProgress);
        // form.addEventListener('change', updateProgress);

        // File upload handling
        const fileInput = document.getElementById('fileInput');
        const fileList = document.getElementById('fileList');
        let uploadedFiles = [];

        fileInput.addEventListener('change', function(e) {
            Array.from(e.target.files).forEach(file => {
                if (file.size > 10 * 1024 * 1024) {
                    alert(`<?php echo app('translator')->get('messages.file_too_large'); ?> ${file.name}`);
                    return;
                }
                
                if (!uploadedFiles.find(f => f.name === file.name)) {
                    uploadedFiles.push(file);
                    addFileToList(file);
                }
            });
            // updateProgress();
        });

        function addFileToList(file) {
            const fileItem = document.createElement('div');
            fileItem.className = 'file-item';
            fileItem.innerHTML = `
                <div class="file-item-info">
                    <i class="fas fa-file-${getFileIcon(file.name)}"></i>
                    <span>${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)</span>
                </div>
                <button type="button" class="remove-file" onclick="removeFile('${file.name}')">
                    <i class="fas fa-times"></i>
                </button>
            `;
            fileList.appendChild(fileItem);
        }

        function getFileIcon(filename) {
            const ext = filename.split('.').pop().toLowerCase();
            const icons = {
                'pdf': 'pdf',
                'doc': 'word',
                'docx': 'word',
                'xls': 'excel',
                'xlsx': 'excel'
            };
            return icons[ext] || 'alt';
        }

        function removeFile(filename) {
            uploadedFiles = uploadedFiles.filter(f => f.name !== filename);
            const items = fileList.querySelectorAll('.file-item');
            items.forEach(item => {
                if (item.textContent.includes(filename)) {
                    item.remove();
                }
            });
            // updateProgress();
        }




        // Validate numeric inputs
        const numericInputs = form.querySelectorAll('input[type="number"]');
        numericInputs.forEach(input => {
            input.addEventListener('input', function() {
                if (this.value < 0) {
                    this.value = 0;
                }
            });
        });

        

        // Initialize progress on load
        // updateProgress();

        // Smooth scroll to top button
        window.addEventListener('scroll', function() {
            const scrollBtn = document.getElementById('scrollTopBtn');
            if (!scrollBtn) {
                const btn = document.createElement('button');
                btn.id = 'scrollTopBtn';
                btn.innerHTML = '<i class="fas fa-arrow-up"></i>';
                btn.style.cssText = `
                    position: fixed;
                    bottom: 2rem;
                    right: 2rem;
                    width: 50px;
                    height: 50px;
                    border-radius: 50%;
                    background: linear-gradient(135deg, #2e8b57, #228b22);
                    color: white;
                    border: none;
                    cursor: pointer;
                    display: none;
                    align-items: center;
                    justify-content: center;
                    font-size: 1.2rem;
                    box-shadow: 0 4px 15px rgba(46, 139, 87, 0.3);
                    transition: all 0.3s ease;
                    z-index: 1000;
                `;
                btn.addEventListener('click', function() {
                    window.scrollTo({ top: 0, behavior: 'smooth' });
                });
                document.body.appendChild(btn);
            }
            
            const scrollTopBtn = document.getElementById('scrollTopBtn');
            if (window.pageYOffset > 300) {
                scrollTopBtn.style.display = 'flex';
            } else {
                scrollTopBtn.style.display = 'none';
            }
        });
    </script> 
    <script>
        (function () {
            'use strict'
            var forms = document.querySelectorAll('.needs-validation')
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\plainteproj\resources\views/plaintes/formulaire.blade.php ENDPATH**/ ?>